/*
**  wsc.h
**
**  Use for both Win16 & Win32.
*/

#ifdef WIN32
  #ifdef _MSC_VER
    /* Microsoft Win32 */
    #define DllExport _declspec(dllexport)
    #define DLLEXPORT
  #else
    /* Borland & Watcom Win32 */
    #define DllExport
    #define DLLEXPORT __stdcall _export
  #endif
#else
  /* all Win16 */
  #define DllExport
  #define DLLEXPORT FAR PASCAL _export
#endif

#ifdef __cplusplus

extern "C" DllExport int DLLEXPORT SioBaud(int,unsigned);
extern "C" DllExport int DLLEXPORT SioBrkSig(int,char);
extern "C" DllExport int DLLEXPORT SioCTS(int);
extern "C" DllExport int DLLEXPORT SioDCD(int);
extern "C" DllExport int DLLEXPORT SioDebug(int);
extern "C" DllExport int DLLEXPORT SioDone(int);
extern "C" DllExport int DLLEXPORT SioDSR(int);
extern "C" DllExport int DLLEXPORT SioDTR(int,char);
extern "C" DllExport int DLLEXPORT SioFlow(int,char);
extern "C" DllExport int DLLEXPORT SioInfo(char);
extern "C" DllExport int DLLEXPORT SioGetc(int);
extern "C" DllExport int DLLEXPORT SioGets(int,LPSTR,unsigned);
extern "C" DllExport int DLLEXPORT SioParms(int,int,int,int);
extern "C" DllExport int DLLEXPORT SioPutc(int,char);
extern "C" DllExport int DLLEXPORT SioPuts(int,LPSTR,unsigned);
extern "C" DllExport int DLLEXPORT SioReset(int,int,int);
extern "C" DllExport int DLLEXPORT SioRI(int);
extern "C" DllExport int DLLEXPORT SioRTS(int,char);
extern "C" DllExport int DLLEXPORT SioRxClear(int);
extern "C" DllExport int DLLEXPORT SioRxQue(int);
extern "C" DllExport int DLLEXPORT SioStatus(int,unsigned);
extern "C" DllExport int DLLEXPORT SioTxClear(int);
extern "C" DllExport int DLLEXPORT SioTxQue(int);
extern "C" DllExport int DLLEXPORT SioUnGetc(int,char);
extern "C" DllExport int DLLEXPORT SioWinError(void);

#else

extern DllExport int DLLEXPORT SioBaud(int,unsigned);
extern DllExport int DLLEXPORT SioBrkSig(int,char);
extern DllExport int DLLEXPORT SioCTS(int);
extern DllExport int DLLEXPORT SioDCD(int);
extern DllExport int DLLEXPORT SioDebug(int);
extern DllExport int DLLEXPORT SioDone(int);
extern DllExport int DLLEXPORT SioDSR(int);
extern DllExport int DLLEXPORT SioDTR(int,char);
extern DllExport int DLLEXPORT SioFlow(int,char);
extern DllExport int DLLEXPORT SioInfo(char);
extern DllExport int DLLEXPORT SioGetc(int);
extern DllExport int DLLEXPORT SioGets(int,LPSTR,unsigned);
extern DllExport int DLLEXPORT SioParms(int,int,int,int);
extern DllExport int DLLEXPORT SioPutc(int,char);
extern DllExport int DLLEXPORT SioPuts(int,LPSTR,unsigned);
extern DllExport int DLLEXPORT SioReset(int,int,int);
extern DllExport int DLLEXPORT SioRI(int);
extern DllExport int DLLEXPORT SioRTS(int,char);
extern DllExport int DLLEXPORT SioRxClear(int);
extern DllExport int DLLEXPORT SioRxQue(int);
extern DllExport int DLLEXPORT SioStatus(int,unsigned);
extern DllExport int DLLEXPORT SioTxClear(int);
extern DllExport int DLLEXPORT SioTxQue(int);
extern DllExport int DLLEXPORT SioUnGetc(int,char);
extern DllExport int DLLEXPORT SioWinError(void);

#endif

#define COM1   0
#define COM2   1
#define COM3   2
#define COM4   3
#define COM5   4
#define COM6   5
#define COM7   6
#define COM8   7
#define COM9   8

/* Parity Codes */

#define NoParity 0
#define OddParity  1
#define EvenParity 2
#define MarkParity 3
#define SpaceParity 4

/* Stop Bit Codes */

#define OneStopBit  0
#define TwoStopBits 2

/* Word Length Codes */

#define WordLength5  5
#define WordLength6  6
#define WordLength7  7
#define WordLength8  8

/* return codes */

#define WSC_NO_DATA   (-100)
#define WSC_RANGE     (-101)
#define WSC_ABORTED   (-102)
#define WSC_WIN32ERR  (-103)
#define WSC_EXPIRED   (-104)
#define IE_BADID      (-1)
#define IE_OPEN       (-2)
#define IE_NOPEN      (-3)
#define IE_MEMORY     (-4)
#define IE_DEFAULT    (-5)
#define IE_HARDWARE   (-10)
#define IE_BYTESIZE   (-11)
#define IE_BAUDRATE   (-12)

/* baud codes */

#define Baud110    0
#define Baud300    1
#define Baud1200   2
#define Baud2400   3
#define Baud4800   4
#define Baud9600   5
#define Baud19200  6
#define Baud38400  7
#define Baud57600  8
#define Baud115200 9

/* SioGetError masks */

#define WSC_RXOVER   0x0001
#define WSC_OVERRUN  0x0002
#define WSC_PARITY   0x0004
#define WSC_FRAME    0x0008
#define WSC_BREAK    0x0010
#define WSC_TXFULL   0x0100
