/*
 * FILE : wsc_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1  (Beta 1)
 * 
 * Copyright (c) 1995,1996
 * The Regents of the University of California and
 * The University of Utah
 *
 */

/* Implementation : PYTHON 1.3 */

#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header:$
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log:$
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

staticforward PyTypeObject swig_varlinktype;

#define is_swig_varlinkobject(op) ((op)->ob_type == &swig_varlinktype)


/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

static PyObject *
swig_newvarlink(void)
{
  swig_varlinkobject *result;
  result = PyMem_NEW(swig_varlinkobject,1);
  result->ob_type = &varlinktype;
  _Py_NewReference(result);
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

static void
swig_addvarlink(swig_varlinkobject *v, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/* swigptr.cfg
 * $Header: /b11/dmb/SWIG/SWIG1.0/swig_lib/config/RCS/swigptr.cfg,v 1.5 1996/08/01 16:28:56 dmb Exp dmb $
 *
 * This file contains two functions :
 *
 *       void  _swig_make_hex(char *_c, void *_ptr, char *type)
 *       char *_swig_get_hex(char *_c, void **ptr, char *type)
 *
 * These are used to convert pointers to and from pointer strings
 * and to perform type checking.
 *
 * You can remap these functions by making a file called "swigptr.cfg" in
 * your the same directory as the interface file you are wrapping.
 *
 * IMPORTANT !!! the function _swig_get_hex returns a non-null char pointer
 * in the event of a type error (this is used to generate an error message).
 * If a type is successfully parsed, a NULL pointer is returned.
 *
 * $Log: swigptr.cfg,v $
 * Revision 1.5  1996/08/01 16:28:56  dmb
 * Took out unused "dt" variable.
 *
 * Revision 1.4  1996/07/23 14:38:42  dmb
 * Minor change to handling of NULL pointers.
 *
 * Revision 1.3  1996/07/17 15:26:08  dmb
 * Made a minor bug fix so pointers of form _0_Type could be used
 * (as described in the manual).   Disable by compiling with -DNO_ZERO.
 *
 * Revision 1.2  1996/06/10 23:42:10  beazley
 * Added const qualifier.
 *
# Revision 1.1  1996/05/22  17:17:47  beazley
# Initial revision
#
 */

static void 
_swig_make_hex (char *_c, const void *_ptr, char *type)
{
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[128], *_r;
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0)
    {
      while (_p > 0)
	{
	  _s = _p & 0xf;
	  *(_r++) = _hex[_s];
	  _p = _p >> 4;
	}
      *_r = '_';
      while (_r >= _result)
	*(_c++) = *(_r--);
    }
  else
    {
      strcpy (_c, "NULL");
    }
  if (_ptr)
    strcpy (_c, type);
}

/* A forward reference; */

static char ***swig_ptr_derived = 0;

static char *
_swig_get_hex (char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *_tt;
  char **eq;
  int i, j, n;
  _p = 0;
  if (*_c == '_')
    {
      _c++;
      while (*_c)
	{
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
	}
#ifdef NO_ZERO
      if (_p == 0)
	{
	  return (char *) _c;
	}
#endif
      _tt = _c;
      if (_t)
	{
	  if (strcmp (_c, _t))
	    {
	      /* Have a type mismatch, we're going to have to do some
	         searching here */
	      i = 0;
	      if (swig_ptr_derived)
		{
		  while (swig_ptr_derived[i])
		    {
		      eq = swig_ptr_derived[i];
		      /* Check type */
		      if (strncmp (_t, eq[0], strlen (eq[0])) == 0)
			{
			  /* Found derived type list for this. */
			  n = strlen (eq[0]);
			  j = 1;
			  while (eq[j])
			    {
			      sprintf (temp_type, "%s%s", eq[j], _t + n);
			      if (strcmp (_c, temp_type) == 0)
				{
				  *ptr = (void *) _p;
				  return (char *) 0;
				}
			      j++;
			    }
			}
		      i++;
		    }
		}
	      *ptr = (void *) _p;
	      return _tt;
	    }
	  else
	    {
	      *ptr = (void *) _p;
	      return (char *) 0;
	    }
	}
      else
	{
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
    }
  else {
#ifdef ALLOW_NULL
      if (strcmp (_c, "NULL") == 0)
	{
	  *ptr = (void *) 0;
	  return (char *) 0;
	}
#endif
      *ptr = (void *) 0;	
      return _c;
    }
}
#define SWIG_init    initsio

#define SWIG_name    "sio"

#include "windows.h"
#include "Wsc.h"
extern int SioBaud(int ,unsigned );
extern int SioBrkSig(int ,char );
extern int SioCTS(int );
extern int SioDCD(int );
extern int SioDebug(int );
extern int SioDone(int );
extern int SioDSR(int );
extern int SioDTR(int ,char );
extern int SioFlow(int ,char );
extern int SioInfo(char );
extern int SioGetc(int );
extern int SioGets(int ,char *,unsigned );
extern int SioParms(int ,int ,int ,int );
extern int SioPutc(int ,char );
extern int SioPuts(int ,char *,unsigned );
extern int SioReset(int ,int ,int );
extern int SioRI(int );
extern int SioRTS(int ,char );
extern int SioRxClear(int );
extern int SioRxQue(int );
extern int SioStatus(int ,unsigned );
extern int SioTxClear(int );
extern int SioTxQue(int );
extern int SioUnGetc(int ,char );
extern int SioWinError();

static PyObject *SerialError;

#define Py_Assert(Expr,ErrObj,Message,ErrorReturn) {\
		if (!(Expr)) {\
			PyErr_SetString((ErrObj),(Message));\
			return (ErrorReturn);\
		}\
	}

static PyObject *_wrap_python_const_COM1;
static PyObject *_wrap_python_const_COM2;
static PyObject *_wrap_python_const_COM3;
static PyObject *_wrap_python_const_COM4;
static PyObject *_wrap_python_const_COM5;
static PyObject *_wrap_python_const_COM6;
static PyObject *_wrap_python_const_COM7;
static PyObject *_wrap_python_const_COM8;
static PyObject *_wrap_python_const_COM9;
static PyObject *_wrap_python_const_NoParity;
static PyObject *_wrap_python_const_OddParity;
static PyObject *_wrap_python_const_EvenParity;
static PyObject *_wrap_python_const_MarkParity;
static PyObject *_wrap_python_const_SpaceParity;
static PyObject *_wrap_python_const_OneStopBit;
static PyObject *_wrap_python_const_TwoStopBits;
static PyObject *_wrap_python_const_WordLength5;
static PyObject *_wrap_python_const_WordLength6;
static PyObject *_wrap_python_const_WordLength7;
static PyObject *_wrap_python_const_WordLength8;
static PyObject *_wrap_python_const_WSC_NO_DATA;
static PyObject *_wrap_python_const_WSC_RANGE;
static PyObject *_wrap_python_const_WSC_ABORTED;
static PyObject *_wrap_python_const_WSC_WIN32ERR;
static PyObject *_wrap_python_const_WSC_EXPIRED;
static PyObject *_wrap_python_const_IE_BADID;
static PyObject *_wrap_python_const_IE_OPEN;
static PyObject *_wrap_python_const_IE_NOPEN;
static PyObject *_wrap_python_const_IE_MEMORY;
static PyObject *_wrap_python_const_IE_DEFAULT;
static PyObject *_wrap_python_const_IE_HARDWARE;
static PyObject *_wrap_python_const_IE_BYTESIZE;
static PyObject *_wrap_python_const_IE_BAUDRATE;
static PyObject *_wrap_python_const_Baud110;
static PyObject *_wrap_python_const_Baud300;
static PyObject *_wrap_python_const_Baud1200;
static PyObject *_wrap_python_const_Baud2400;
static PyObject *_wrap_python_const_Baud4800;
static PyObject *_wrap_python_const_Baud9600;
static PyObject *_wrap_python_const_Baud19200;
static PyObject *_wrap_python_const_Baud38400;
static PyObject *_wrap_python_const_Baud57600;
static PyObject *_wrap_python_const_Baud115200;
static PyObject *_wrap_python_const_WSC_RXOVER;
static PyObject *_wrap_python_const_WSC_OVERRUN;
static PyObject *_wrap_python_const_WSC_PARITY;
static PyObject *_wrap_python_const_WSC_FRAME;
static PyObject *_wrap_python_const_WSC_BREAK;
static PyObject *_wrap_python_const_WSC_TXFULL;


static char SioWinErrorDoc[] = "int SioWinError() for error code WSC_WIN32ERR, returns the WIN32 error";

static PyObject *_wrap_SioWinError(PyObject *self, PyObject *args) {
    int  _result;

	Py_Assert(	PyArg_ParseTuple(args,""),
				PyExc_SyntaxError,
				SioWinErrorDoc,
				NULL);

    _result = SioWinError();
    return Py_BuildValue("i",_result);
}

typedef struct {
	int i;
	char* txt;
} SioErrTable;

static SioErrTable sioErrors[] = {

	WSC_NO_DATA,	"No incoming serial data is available",
	WSC_RANGE,		"A parameter is out of range",
	WSC_ABORTED,	"The shareware version of WSC corrupted",
	WSC_WIN32ERR,	"Win32 system error",
	WSC_EXPIRED,	"The shareware version of WSC has expired",
	IE_BADID,		"No such port",
	IE_OPEN,		"Port already opened",
	IE_NOPEN,		"Port not opened. Call SioReset first",
	IE_MEMORY,		"Cannot allocate memory for queues",
	IE_DEFAULT,		"Error in default parameters",
	IE_HARDWARE,	"Hardware not present",
	IE_BYTESIZE,	"Unsupported byte size",
	IE_BAUDRATE,	"Unsupported baud rate",
	0,				NULL
};


static char SioErrorTextDoc[] = "char* SioErrorText(int errNum) - returns the error message associated with errNum";

static PyObject *SioErrorText(PyObject *self, PyObject *args) {
    char* _result = NULL;
    int  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"i",&_arg0),
				PyExc_SyntaxError,
				SioErrorTextDoc,
				NULL);

	char  *Win32ErrMsg;

	if (_arg0 >= 0) {
		_result = "Success";
	} else if (_arg0 == WSC_WIN32ERR) {
		DWORD dwError;

		dwError = (DWORD) SioWinError();
		if(FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM|FORMAT_MESSAGE_ALLOCATE_BUFFER|80 ,
						 NULL, dwError,
						 MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US),
						 (LPTSTR) &Win32ErrMsg, 0, NULL)
              > 0) {
			_result = Win32ErrMsg;
         } else	{
			_result = "Unknown Win32 Error";
         }
   	} else {
		int i = 0;
		while (sioErrors[i].txt) {
			if (sioErrors[i].i == _arg0) {
				_result = sioErrors[i].txt;
				break;
			}
			i++;
		}
	}
	if (!_result) {
		_result = "Unknown error";
	}
    return Py_BuildValue("s",_result);
}


static char SioBaudDoc[] = "int SioBaud(int port, int baud) - sets baud rate";

static PyObject *_wrap_SioBaud(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;
    unsigned  _arg1;

	Py_Assert(	PyArg_ParseTuple(args,"ii",&_arg0,&_arg1),
				PyExc_SyntaxError,
				SioBaudDoc,
				NULL);

    _result = SioBaud(_arg0,_arg1);
    return Py_BuildValue("i",_result);
}


static char SioBrkSigDoc[] = "int SioBrkSig(int port, char cmd=A|C|D) - Assert|Cancel|Detect break signal";

static PyObject *_wrap_SioBrkSig(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;
    char  _arg1;

	Py_Assert(	PyArg_ParseTuple(args,"ic",&_arg0,&_arg1),
				PyExc_SyntaxError,
				SioBrkSigDoc,
				NULL);

    _result = SioBrkSig(_arg0,_arg1);
    return Py_BuildValue("i",_result);
}


static char SioCTSDoc[] = "int SioCTS(int port) - read Clear To Send state";

static PyObject *_wrap_SioCTS(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"i",&_arg0),
				PyExc_SyntaxError,
				SioCTSDoc,
				NULL);

    _result = SioCTS(_arg0);
    return Py_BuildValue("i",_result);
}


static char SioDCDDoc[] = "int SioCDC(int port) - read Data Carrier Detect state";

static PyObject *_wrap_SioDCD(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"i",&_arg0),
				PyExc_SyntaxError,
				SioDCDDoc,
				NULL);

    _result = SioDCD(_arg0);
    return Py_BuildValue("i",_result);
}


static char SioDebugDoc[] = "int SioDebug(int port) - ???";

static PyObject *_wrap_SioDebug(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"i",&_arg0),
				PyExc_SyntaxError,
				SioDebugDoc,
				NULL);

    _result = SioDebug(_arg0);
    return Py_BuildValue("i",_result);
}


static char SioDoneDoc[] = "int SioDone(int port) - close port connection";

static PyObject *_wrap_SioDone(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"i",&_arg0),
				PyExc_SyntaxError,
				SioDoneDoc,
				NULL);

	_result = SioDone(_arg0);
    return Py_BuildValue("i",_result);
}


static char SioDSRDoc[] = "int SioDSR(int port) - read Data Set Ready state";

static PyObject *_wrap_SioDSR(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"i",&_arg0),
				PyExc_SyntaxError,
				SioDSRDoc,
				NULL);

	_result = SioDSR(_arg0);
    return Py_BuildValue("i",_result);
}


static char SioDTRDoc[] = "int SioDTR(int port, char cmd=S|C|R) - Set|Clear|Read Data Terminal Ready signal";

static PyObject *_wrap_SioDTR(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;
    char  _arg1;

	Py_Assert(	PyArg_ParseTuple(args,"ic",&_arg0,&_arg1),
				PyExc_SyntaxError,
				SioDTRDoc,
				NULL);

    _result = SioDTR(_arg0,_arg1);
    return Py_BuildValue("i",_result);
}


static char SioFlowDoc[] = "int SioFlow(int port char cmd=H|S|N) - set flow control to Hardware|Software|None";

static PyObject *_wrap_SioFlow(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;
    char  _arg1;

	Py_Assert(	PyArg_ParseTuple(args,"ic",&_arg0,&_arg1),
				PyExc_SyntaxError,
				SioFlowDoc,
				NULL);

    _result = SioFlow(_arg0,_arg1);
    return Py_BuildValue("i",_result);
}


static char SioInfoDoc[] = "int SioInfo(char cmd=V) - returns library Version";

static PyObject *_wrap_SioInfo(PyObject *self, PyObject *args) {
    int  _result;
    char  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"c",&_arg0),
				PyExc_SyntaxError,
				SioInfoDoc,
				NULL);

    _result = SioInfo(_arg0);
    return Py_BuildValue("i",_result);
}


static char SioGetcDoc[] = "int SioGetc(int port) - get one char from port";

static PyObject *_wrap_SioGetc(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"i",&_arg0),
				PyExc_SyntaxError,
				SioGetcDoc,
				NULL);

    _result = SioGetc(_arg0);
    return Py_BuildValue("i",_result);
}


static char SioGetsDoc[] = "char* SioGets(int port, int cnt) - try to read cnt bytes from port";

static PyObject *_wrap_SioGets(PyObject *self, PyObject *args) {
    int  port;
    unsigned size;
    PyObject *buffer;
    int n;
    PyObject *errVal;
    PyObject *errText;

    Py_Assert(PyArg_ParseTuple(args,"ii",&port,&size),
		  PyExc_SyntaxError,
		  SioGetsDoc,
		  NULL);

    buffer = PyString_FromStringAndSize((char *)NULL, size);
    Py_Assert(buffer,
		  PyExc_MemoryError,
		  "SioGets cannot allocate receive buffer",
		  NULL);

    n = SioGets(port, PyString_AsString(buffer), size);

    if (n < 0) {
        Py_DECREF(buffer);
        errVal = Py_BuildValue("(i)", n);
        if (errVal != NULL) {
			errText = SioErrorText(self, errVal);
			if (errText != NULL) {
				PyErr_SetObject(SerialError, errText);
				Py_DECREF(errText);
			}
			Py_DECREF(errVal);
        }
        return NULL;
    }

    if ((unsigned)n != size)
        _PyString_Resize(&buffer, n);
    
    return buffer;
}


static char SioParmsDoc[] = "int SioParms(int port, int parity, int stopBits, int dataBits) - set open port parameters";

static PyObject *_wrap_SioParms(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;

	Py_Assert(	PyArg_ParseTuple(args,"iiii",&_arg0,&_arg1,&_arg2,&_arg3),
				PyExc_SyntaxError,
				SioParmsDoc,
				NULL);

    _result = SioParms(_arg0,_arg1,_arg2,_arg3);
    return Py_BuildValue("i",_result);
}


static char SioPutcDoc[] = "int SioPutc(int port, char chr) - write chr to port";

static PyObject *_wrap_SioPutc(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;
    int  cnt;
    char * _arg1;

	Py_Assert(	PyArg_ParseTuple(args,"is#",&_arg0,&_arg1,&cnt),
				PyExc_SyntaxError,
				SioPutcDoc,
				NULL);

    _result = SioPutc(_arg0,_arg1[0]);
    return Py_BuildValue("i",_result);
}


static char SioPutsDoc[] = "int SioPuts(int port, char* buf, int cnt) - write cnt bytes of buf to port";

static PyObject *_wrap_SioPuts(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;
    int  cnt;
    char * _arg1;
    unsigned  _arg2;

	Py_Assert(	PyArg_ParseTuple(args,"is#i",&_arg0,&_arg1,&cnt,&_arg2),
				PyExc_SyntaxError,
				SioPutsDoc,
				NULL);

    _result = SioPuts(_arg0,_arg1,_arg2);
    return Py_BuildValue("i",_result);
}


static char SioResetDoc[] = "int SioReset(int port, int rxBufSize, int txBufSize) - open port";

static PyObject *_wrap_SioReset(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;

	Py_Assert(	PyArg_ParseTuple(args,"iii",&_arg0,&_arg1,&_arg2),
				PyExc_SyntaxError,
				SioResetDoc,
				NULL);

    _result = SioReset(_arg0,_arg1,_arg2);
    return Py_BuildValue("i",_result);
}


static char SioRIDoc[] = "int SioRI(int port) - read Ring Indicator state";

static PyObject *_wrap_SioRI(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"i",&_arg0),
				PyExc_SyntaxError,
				SioRIDoc,
				NULL);

    _result = SioRI(_arg0);
    return Py_BuildValue("i",_result);
}


static char SioRTSDoc[] = "int SioRTS(int port, char cmd=S|C|R) - Set|Clear|Read Ready To Send signal";

static PyObject *_wrap_SioRTS(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;
    char  _arg1;

	Py_Assert(	PyArg_ParseTuple(args,"ic",&_arg0,&_arg1),
				PyExc_SyntaxError,
				SioRTSDoc,
				NULL);

    _result = SioRTS(_arg0,_arg1);
    return Py_BuildValue("i",_result);
}


static char SioRxClearDoc[] = "int SioRxClear(int port) - clear receive buffer";

static PyObject *_wrap_SioRxClear(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"i",&_arg0),
				PyExc_SyntaxError,
				SioRxClearDoc,
				NULL);

    _result = SioRxClear(_arg0);
    return Py_BuildValue("i",_result);
}


static char SioRxQueDoc[] = "int SioRxQue(int port) - return number of chars in receive buffer";

static PyObject *_wrap_SioRxQue(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"i",&_arg0),
				PyExc_SyntaxError,
				SioRxQueDoc,
				NULL);

    _result = SioRxQue(_arg0);
    return Py_BuildValue("i",_result);
}


static char SioStatusDoc[] = "int SioStatus(int port, unsigned mask) - test for WSC_* errors";

static PyObject *_wrap_SioStatus(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;
    unsigned  _arg1;

	Py_Assert(	PyArg_ParseTuple(args,"ii",&_arg0,&_arg1),
				PyExc_SyntaxError,
				SioStatusDoc,
				NULL);

    _result = SioStatus(_arg0,_arg1);
    return Py_BuildValue("i",_result);
}


static char SioTxClearDoc[] = "int SioTxClear(int port) - clear transmit buffer";

static PyObject *_wrap_SioTxClear(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"i",&_arg0),
				PyExc_SyntaxError,
				SioTxClearDoc,
				NULL);

    _result = SioTxClear(_arg0);
    return Py_BuildValue("i",_result);
}


static char SioTxQueDoc[] = "int SioTxQue(int port) - return number of chars in transmit buffer";

static PyObject *_wrap_SioTxQue(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;

	Py_Assert(	PyArg_ParseTuple(args,"i",&_arg0),
				PyExc_SyntaxError,
				SioTxQueDoc,
				NULL);

    _result = SioTxQue(_arg0);
    return Py_BuildValue("i",_result);
}


static char SioUnGetcDoc[] = "int SioUnGetc(int port, char chr) - put chr back into receive buffer";

static PyObject *_wrap_SioUnGetc(PyObject *self, PyObject *args) {
    int  _result;
    int  _arg0;
    char  _arg1;

	Py_Assert(	PyArg_ParseTuple(args,"ic",&_arg0,&_arg1),
				PyExc_SyntaxError,
				SioUnGetcDoc,
				NULL);

    _result = SioUnGetc(_arg0,_arg1);
    return Py_BuildValue("i",_result);
}


static PyMethodDef sioMethods[] = {
	 { "SioWinError", _wrap_SioWinError, 1, SioWinErrorDoc },
	 { "SioUnGetc", _wrap_SioUnGetc, 1, SioUnGetcDoc },
	 { "SioTxQue", _wrap_SioTxQue, 1, SioTxQueDoc },
	 { "SioTxClear", _wrap_SioTxClear, 1, SioTxClearDoc },
	 { "SioStatus", _wrap_SioStatus, 1, SioStatusDoc },
	 { "SioRxQue", _wrap_SioRxQue, 1, SioRxQueDoc },
	 { "SioRxClear", _wrap_SioRxClear, 1, SioRxClearDoc },
	 { "SioRTS", _wrap_SioRTS, 1, SioRTSDoc },
	 { "SioRI", _wrap_SioRI, 1, SioRIDoc },
	 { "SioReset", _wrap_SioReset, 1, SioResetDoc },
	 { "SioPuts", _wrap_SioPuts, 1, SioPutsDoc },
	 { "SioPutc", _wrap_SioPutc, 1, SioPutcDoc },
	 { "SioParms", _wrap_SioParms, 1, SioParmsDoc },
	 { "SioGets", _wrap_SioGets, 1, SioGetsDoc },
	 { "SioGetc", _wrap_SioGetc, 1, SioGetcDoc },
	 { "SioInfo", _wrap_SioInfo, 1, SioInfoDoc },
	 { "SioFlow", _wrap_SioFlow, 1, SioFlowDoc },
	 { "SioDTR", _wrap_SioDTR, 1, SioDTRDoc },
	 { "SioDSR", _wrap_SioDSR, 1, SioDSRDoc },
	 { "SioDone", _wrap_SioDone, 1, SioDoneDoc },
	 { "SioDebug", _wrap_SioDebug, 1, SioDebugDoc },
	 { "SioDCD", _wrap_SioDCD, 1, SioDCDDoc },
	 { "SioCTS", _wrap_SioCTS, 1, SioCTSDoc },
	 { "SioBrkSig", _wrap_SioBrkSig, 1, SioBrkSigDoc },
	 { "SioBaud", _wrap_SioBaud, 1, SioBaudDoc },
	 { "SioErrorText", SioErrorText, 1, SioErrorTextDoc },
	 { NULL, NULL }
};
/*
 * This is the pointer type-equivalence table. 
 * (Used by the SWIG pointer type-checker).
 */
static char *_unsigned_long_derived[] = { "_unsigned_long", "_long",0 };
static char *_signed_long_derived[] = { "_signed_long", "_long",0 };
static char *_long_derived[] = { "_long", "_unsigned_long","_signed_long",0 };
static char *_unsigned_short_derived[] = { "_unsigned_short", "_short",0 };
static char *_signed_short_derived[] = { "_signed_short", "_short",0 };
static char *_short_derived[] = { "_short", "_unsigned_short","_signed_short",0 };
static char *_unsigned_int_derived[] = { "_unsigned_int", "_int",0 };
static char *_signed_int_derived[] = { "_signed_int", "_int",0 };
static char *_int_derived[] = { "_int", "_unsigned_int","_signed_int",0 };
static char **_swig_ptr_python[] = {
	 _unsigned_long_derived,
	 _signed_long_derived,
	 _long_derived,
	 _unsigned_short_derived,
	 _signed_short_derived,
	 _short_derived,
	 _unsigned_int_derived,
	 _signed_int_derived,
	 _int_derived,
	 0
};

static PyObject *SWIG_globals;

static char sioModuleDoc[] = "Interface to the Serial Communications DLLs of MarshallSoft Computing, Inc.";

void initsio() {
	PyObject *m, *d;
	SWIG_globals = swig_newvarlink();

	m = Py_InitModule4("sio", sioMethods, sioModuleDoc, NULL, PYTHON_API_VERSION);

	d = PyModule_GetDict(m);

	SerialError = PyString_FromString("serial.SioError");
 	PyDict_SetItemString(d, "SioError", SerialError);

	_wrap_python_const_COM1 = PyInt_FromLong(0);
	PyDict_SetItemString(d,"COM1", _wrap_python_const_COM1);
	_wrap_python_const_COM2 = PyInt_FromLong(1);
	PyDict_SetItemString(d,"COM2", _wrap_python_const_COM2);
	_wrap_python_const_COM3 = PyInt_FromLong(2);
	PyDict_SetItemString(d,"COM3", _wrap_python_const_COM3);
	_wrap_python_const_COM4 = PyInt_FromLong(3);
	PyDict_SetItemString(d,"COM4", _wrap_python_const_COM4);
	_wrap_python_const_COM5 = PyInt_FromLong(4);
	PyDict_SetItemString(d,"COM5", _wrap_python_const_COM5);
	_wrap_python_const_COM6 = PyInt_FromLong(5);
	PyDict_SetItemString(d,"COM6", _wrap_python_const_COM6);
	_wrap_python_const_COM7 = PyInt_FromLong(6);
	PyDict_SetItemString(d,"COM7", _wrap_python_const_COM7);
	_wrap_python_const_COM8 = PyInt_FromLong(7);
	PyDict_SetItemString(d,"COM8", _wrap_python_const_COM8);
	_wrap_python_const_COM9 = PyInt_FromLong(8);
	PyDict_SetItemString(d,"COM9", _wrap_python_const_COM9);
	_wrap_python_const_NoParity = PyInt_FromLong(0);
	PyDict_SetItemString(d,"NoParity", _wrap_python_const_NoParity);
	_wrap_python_const_OddParity = PyInt_FromLong(1);
	PyDict_SetItemString(d,"OddParity", _wrap_python_const_OddParity);
	_wrap_python_const_EvenParity = PyInt_FromLong(2);
	PyDict_SetItemString(d,"EvenParity", _wrap_python_const_EvenParity);
	_wrap_python_const_MarkParity = PyInt_FromLong(3);
	PyDict_SetItemString(d,"MarkParity", _wrap_python_const_MarkParity);
	_wrap_python_const_SpaceParity = PyInt_FromLong(4);
	PyDict_SetItemString(d,"SpaceParity", _wrap_python_const_SpaceParity);
	_wrap_python_const_OneStopBit = PyInt_FromLong(0);
	PyDict_SetItemString(d,"OneStopBit", _wrap_python_const_OneStopBit);
	_wrap_python_const_TwoStopBits = PyInt_FromLong(2);
	PyDict_SetItemString(d,"TwoStopBits", _wrap_python_const_TwoStopBits);
	_wrap_python_const_WordLength5 = PyInt_FromLong(5);
	PyDict_SetItemString(d,"WordLength5", _wrap_python_const_WordLength5);
	_wrap_python_const_WordLength6 = PyInt_FromLong(6);
	PyDict_SetItemString(d,"WordLength6", _wrap_python_const_WordLength6);
	_wrap_python_const_WordLength7 = PyInt_FromLong(7);
	PyDict_SetItemString(d,"WordLength7", _wrap_python_const_WordLength7);
	_wrap_python_const_WordLength8 = PyInt_FromLong(8);
	PyDict_SetItemString(d,"WordLength8", _wrap_python_const_WordLength8);
	_wrap_python_const_WSC_NO_DATA = PyInt_FromLong((-100));
	PyDict_SetItemString(d,"WSC_NO_DATA", _wrap_python_const_WSC_NO_DATA);
	_wrap_python_const_WSC_RANGE = PyInt_FromLong((-101));
	PyDict_SetItemString(d,"WSC_RANGE", _wrap_python_const_WSC_RANGE);
	_wrap_python_const_WSC_ABORTED = PyInt_FromLong((-102));
	PyDict_SetItemString(d,"WSC_ABORTED", _wrap_python_const_WSC_ABORTED);
	_wrap_python_const_WSC_WIN32ERR = PyInt_FromLong((-103));
	PyDict_SetItemString(d,"WSC_WIN32ERR", _wrap_python_const_WSC_WIN32ERR);
	_wrap_python_const_WSC_EXPIRED = PyInt_FromLong((-104));
	PyDict_SetItemString(d,"WSC_EXPIRED", _wrap_python_const_WSC_EXPIRED);
	_wrap_python_const_IE_BADID = PyInt_FromLong((-1));
	PyDict_SetItemString(d,"IE_BADID", _wrap_python_const_IE_BADID);
	_wrap_python_const_IE_OPEN = PyInt_FromLong((-2));
	PyDict_SetItemString(d,"IE_OPEN", _wrap_python_const_IE_OPEN);
	_wrap_python_const_IE_NOPEN = PyInt_FromLong((-3));
	PyDict_SetItemString(d,"IE_NOPEN", _wrap_python_const_IE_NOPEN);
	_wrap_python_const_IE_MEMORY = PyInt_FromLong((-4));
	PyDict_SetItemString(d,"IE_MEMORY", _wrap_python_const_IE_MEMORY);
	_wrap_python_const_IE_DEFAULT = PyInt_FromLong((-5));
	PyDict_SetItemString(d,"IE_DEFAULT", _wrap_python_const_IE_DEFAULT);
	_wrap_python_const_IE_HARDWARE = PyInt_FromLong((-10));
	PyDict_SetItemString(d,"IE_HARDWARE", _wrap_python_const_IE_HARDWARE);
	_wrap_python_const_IE_BYTESIZE = PyInt_FromLong((-11));
	PyDict_SetItemString(d,"IE_BYTESIZE", _wrap_python_const_IE_BYTESIZE);
	_wrap_python_const_IE_BAUDRATE = PyInt_FromLong((-12));
	PyDict_SetItemString(d,"IE_BAUDRATE", _wrap_python_const_IE_BAUDRATE);
	_wrap_python_const_Baud110 = PyInt_FromLong(0);
	PyDict_SetItemString(d,"Baud110", _wrap_python_const_Baud110);
	_wrap_python_const_Baud300 = PyInt_FromLong(1);
	PyDict_SetItemString(d,"Baud300", _wrap_python_const_Baud300);
	_wrap_python_const_Baud1200 = PyInt_FromLong(2);
	PyDict_SetItemString(d,"Baud1200", _wrap_python_const_Baud1200);
	_wrap_python_const_Baud2400 = PyInt_FromLong(3);
	PyDict_SetItemString(d,"Baud2400", _wrap_python_const_Baud2400);
	_wrap_python_const_Baud4800 = PyInt_FromLong(4);
	PyDict_SetItemString(d,"Baud4800", _wrap_python_const_Baud4800);
	_wrap_python_const_Baud9600 = PyInt_FromLong(5);
	PyDict_SetItemString(d,"Baud9600", _wrap_python_const_Baud9600);
	_wrap_python_const_Baud19200 = PyInt_FromLong(6);
	PyDict_SetItemString(d,"Baud19200", _wrap_python_const_Baud19200);
	_wrap_python_const_Baud38400 = PyInt_FromLong(7);
	PyDict_SetItemString(d,"Baud38400", _wrap_python_const_Baud38400);
	_wrap_python_const_Baud57600 = PyInt_FromLong(8);
	PyDict_SetItemString(d,"Baud57600", _wrap_python_const_Baud57600);
	_wrap_python_const_Baud115200 = PyInt_FromLong(9);
	PyDict_SetItemString(d,"Baud115200", _wrap_python_const_Baud115200);
	_wrap_python_const_WSC_RXOVER = PyInt_FromLong(0x0001);
	PyDict_SetItemString(d,"WSC_RXOVER", _wrap_python_const_WSC_RXOVER);
	_wrap_python_const_WSC_OVERRUN = PyInt_FromLong(0x0002);
	PyDict_SetItemString(d,"WSC_OVERRUN", _wrap_python_const_WSC_OVERRUN);
	_wrap_python_const_WSC_PARITY = PyInt_FromLong(0x0004);
	PyDict_SetItemString(d,"WSC_PARITY", _wrap_python_const_WSC_PARITY);
	_wrap_python_const_WSC_FRAME = PyInt_FromLong(0x0008);
	PyDict_SetItemString(d,"WSC_FRAME", _wrap_python_const_WSC_FRAME);
	_wrap_python_const_WSC_BREAK = PyInt_FromLong(0x0010);
	PyDict_SetItemString(d,"WSC_BREAK", _wrap_python_const_WSC_BREAK);
	_wrap_python_const_WSC_TXFULL = PyInt_FromLong(0x0100);
	PyDict_SetItemString(d,"WSC_TXFULL", _wrap_python_const_WSC_TXFULL);
	swig_ptr_derived = _swig_ptr_python;
}
