////
//  This file was generated by VCL Generator
//  Copyright 1998 - Morgan Martinet
//  07/04/98 17:26:15
//  it declares the content of the module _Graphics
////

unit Python_Graphics;

interface

uses
   Windows,
   Graphics,
   Classes,
   SysUtils,
   PythonEngine;

type
  TModule_Graphics = class( TPythonModule )
  public
    procedure Initialize; override;
  end;

  function TGraphicsObject_ReadAttribute( Self : TGraphicsObject; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TGraphicsObject_WriteAttribute( Self : TGraphicsObject; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TFont_ReadAttribute( Self : TFont; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TFont_WriteAttribute( Self : TFont; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TPen_ReadAttribute( Self : TPen; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TPen_WriteAttribute( Self : TPen; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TBrush_ReadAttribute( Self : TBrush; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TBrush_WriteAttribute( Self : TBrush; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCanvas_ReadAttribute( Self : TCanvas; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCanvas_WriteAttribute( Self : TCanvas; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TGraphic_ReadAttribute( Self : TGraphic; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TGraphic_WriteAttribute( Self : TGraphic; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TPicture_ReadAttribute( Self : TPicture; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TPicture_WriteAttribute( Self : TPicture; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TMetafileCanvas_ReadAttribute( Self : TMetafileCanvas; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TMetafileCanvas_WriteAttribute( Self : TMetafileCanvas; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TSharedImage_ReadAttribute( Self : TSharedImage; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TSharedImage_WriteAttribute( Self : TSharedImage; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TMetafileImage_ReadAttribute( Self : TMetafileImage; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TMetafileImage_WriteAttribute( Self : TMetafileImage; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TMetafile_ReadAttribute( Self : TMetafile; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TMetafile_WriteAttribute( Self : TMetafile; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TBitmapImage_ReadAttribute( Self : TBitmapImage; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TBitmapImage_WriteAttribute( Self : TBitmapImage; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TBitmap_ReadAttribute( Self : TBitmap; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TBitmap_WriteAttribute( Self : TBitmap; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TIconImage_ReadAttribute( Self : TIconImage; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TIconImage_WriteAttribute( Self : TIconImage; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TIcon_ReadAttribute( Self : TIcon; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TIcon_WriteAttribute( Self : TIcon; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;

  procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 

implementation

uses
   Delphi_Classes,
   Python_Classes,
   Delphi_System,
   Delphi_Graphics,
   Python_System,
   Py_Misc,
   PyRecords,
   PyDelphiAssoc;

var
  IsInitialized : Boolean;
  gGraphics : TModule_Graphics;
procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 
begin
  if IsInitialized then
    Exit;
  IsInitialized := True;
  gGraphics := TModule_Graphics.Create( AOwner );
  with gGraphics do
    begin
      Engine := AEngine;
      ModuleName := '_Graphics';
    end;
end;

///////////// Functions for class TGraphicsObject //////////////////

function TGraphicsObject_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyGraphicsObject;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TGraphicsObject.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyGraphicsObject.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TGraphicsObject_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TGraphicsObject;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TGraphicsObject) then begin
      ErrorWrongExpectedType( argSelf, 'TGraphicsObject' );
      Exit;
    end;
    realObj := TGraphicsObject(obj);
    // Check attribute
    Result := TGraphicsObject_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TGraphicsObject_ReadAttribute( Self : TGraphicsObject; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'OnChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OwnerCriticalSection' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'PRTLCriticalSection' ); Result := nil; end
    else Result := TPersistent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TGraphicsObject_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TGraphicsObject;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TGraphicsObject) then begin
      ErrorWrongExpectedType( argSelf, 'TGraphicsObject' );
      Exit;
    end;
    realObj := TGraphicsObject(obj);
    // Check attribute
    Result := TGraphicsObject_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TGraphicsObject_WriteAttribute( Self : TGraphicsObject; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'OnChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGraphicsObject then
          with TPyGraphicsObject(Self) do
            OnChange := EventOnChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OwnerCriticalSection' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'PRTLCriticalSection' );
    end else Result := TPersistent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TFont //////////////////

function TFont_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyFont;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TFont.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyFont.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TFont_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TFont;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TFont) then begin
      ErrorWrongExpectedType( argSelf, 'TFont' );
      Exit;
    end;
    realObj := TFont(obj);
    // Check attribute
    Result := TFont_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TFont_ReadAttribute( Self : TFont; argSelf : PPyObject; key : PChar ) : PPyObject;
var
  tmpStyle : TFontStyles;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'FontAdapter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'IChangeNotifier' ); Result := nil; end
    else if CompareText( key, 'Handle' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'HFont' ); Result := nil; end
    else if CompareText( key, 'PixelsPerInch' ) = 0 then Result := VariantAsPyObject( Self.PixelsPerInch )
    else if CompareText( key, 'Charset' ) = 0 then Result := VariantAsPyObject( Integer( Self.Charset ) )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Height' ) = 0 then Result := VariantAsPyObject( Self.Height )
    else if CompareText( key, 'Name' ) = 0 then Result := VariantAsPyObject( Self.Name )
    else if CompareText( key, 'Pitch' ) = 0 then Result := VariantAsPyObject( Integer( Self.Pitch ) )
    else if CompareText( key, 'Size' ) = 0 then Result := VariantAsPyObject( Self.Size )
    else if CompareText( key, 'Style' ) = 0 then begin
      tmpStyle := Self.Style;
      Result := SetToList( @tmpStyle, sizeof(tmpStyle) )
    end
    else Result := TGraphicsObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TFont_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TFont;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TFont) then begin
      ErrorWrongExpectedType( argSelf, 'TFont' );
      Exit;
    end;
    realObj := TFont(obj);
    // Check attribute
    Result := TFont_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TFont_WriteAttribute( Self : TFont; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
  tmpStyle : TFontStyles;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'FontAdapter' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'IChangeNotifier' );
    end else if CompareText( key, 'Handle' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'HFont' );
    end else if CompareText( key, 'PixelsPerInch' ) = 0 then begin
      Self.PixelsPerInch := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Charset' ) = 0 then begin
      Self.Charset := TFontCharset(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Height' ) = 0 then begin
      Self.Height := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Name' ) = 0 then begin
      Self.Name := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Pitch' ) = 0 then begin
      Self.Pitch := TFontPitch(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Size' ) = 0 then begin
      Self.Size := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Style' ) = 0 then begin
      if PyList_Check(value) then begin
        ListToSet( value, @tmpStyle, sizeof(tmpStyle) );
        Self.Style := tmpStyle;
        Result := PyInt_FromLong(0);
      end else
        ErrorWrongSetPropertyType( argSelf, 'Style', 'TFontStyles' );
    end else Result := TGraphicsObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TPen //////////////////

function TPen_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyPen;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TPen.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyPen.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TPen_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPen;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPen) then begin
      ErrorWrongExpectedType( argSelf, 'TPen' );
      Exit;
    end;
    realObj := TPen(obj);
    // Check attribute
    Result := TPen_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TPen_ReadAttribute( Self : TPen; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Handle' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'HPen' ); Result := nil; end
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Mode' ) = 0 then Result := VariantAsPyObject( Integer( Self.Mode ) )
    else if CompareText( key, 'Style' ) = 0 then Result := VariantAsPyObject( Integer( Self.Style ) )
    else if CompareText( key, 'Width' ) = 0 then Result := VariantAsPyObject( Self.Width )
    else Result := TGraphicsObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TPen_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPen;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPen) then begin
      ErrorWrongExpectedType( argSelf, 'TPen' );
      Exit;
    end;
    realObj := TPen(obj);
    // Check attribute
    Result := TPen_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TPen_WriteAttribute( Self : TPen; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Handle' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'HPen' );
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Mode' ) = 0 then begin
      Self.Mode := TPenMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Style' ) = 0 then begin
      Self.Style := TPenStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Width' ) = 0 then begin
      Self.Width := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TGraphicsObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TBrush //////////////////

function TBrush_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyBrush;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TBrush.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyBrush.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TBrush_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TBrush;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TBrush) then begin
      ErrorWrongExpectedType( argSelf, 'TBrush' );
      Exit;
    end;
    realObj := TBrush(obj);
    // Check attribute
    Result := TBrush_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TBrush_ReadAttribute( Self : TBrush; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Bitmap' ) = 0 then Result := GetPythonObject( Self.Bitmap, 'Graphics', 'TBitmap' )
    else if CompareText( key, 'Handle' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'HBrush' ); Result := nil; end
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Style' ) = 0 then Result := VariantAsPyObject( Integer( Self.Style ) )
    else Result := TGraphicsObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TBrush_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TBrush;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TBrush) then begin
      ErrorWrongExpectedType( argSelf, 'TBrush' );
      Exit;
    end;
    realObj := TBrush(obj);
    // Check attribute
    Result := TBrush_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TBrush_WriteAttribute( Self : TBrush; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Bitmap' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TBitmap then begin
        Self.Bitmap := TBitmap( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Bitmap', 'TBitmap' );
    end else if CompareText( key, 'Handle' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'HBrush' );
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Style' ) = 0 then begin
      Self.Style := TBrushStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else Result := TGraphicsObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCanvas //////////////////

function TCanvas_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCanvas;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TCanvas.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCanvas.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCanvas_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCanvas;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCanvas) then begin
      ErrorWrongExpectedType( argSelf, 'TCanvas' );
      Exit;
    end;
    realObj := TCanvas(obj);
    // Check attribute
    Result := TCanvas_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCanvas_ReadAttribute( Self : TCanvas; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'ClipRect' ) = 0 then Result := CreateRect( Self.ClipRect ).GetSelf
    else if CompareText( key, 'Handle' ) = 0 then Result := VariantAsPyObject( Self.Handle )
    else if CompareText( key, 'LockCount' ) = 0 then Result := VariantAsPyObject( Self.LockCount )
    else if CompareText( key, 'PenPos' ) = 0 then Result := CreatePoint( Self.PenPos ).GetSelf
    else if CompareText( key, 'OnChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnChanging' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'Brush' ) = 0 then Result := GetPythonObject( Self.Brush, 'Graphics', 'TBrush' )
    else if CompareText( key, 'CopyMode' ) = 0 then Result := VariantAsPyObject( Self.CopyMode )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'Graphics', 'TFont' )
    else if CompareText( key, 'Pen' ) = 0 then Result := GetPythonObject( Self.Pen, 'Graphics', 'TPen' )
    else Result := TPersistent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCanvas_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCanvas;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCanvas) then begin
      ErrorWrongExpectedType( argSelf, 'TCanvas' );
      Exit;
    end;
    realObj := TCanvas(obj);
    // Check attribute
    Result := TCanvas_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCanvas_WriteAttribute( Self : TCanvas; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'ClipRect' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Handle' ) = 0 then begin
      Self.Handle := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'LockCount' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'PenPos' ) = 0 then begin
      Self.PenPos := PyObjectAsPoint( Value );      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCanvas then
          with TPyCanvas(Self) do
            OnChange := EventOnChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnChanging' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChanging := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyCanvas then
          with TPyCanvas(Self) do
            OnChanging := EventOnChanging;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'Brush' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TBrush then begin
        Self.Brush := TBrush( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Brush', 'TBrush' );
    end else if CompareText( key, 'CopyMode' ) = 0 then begin
      Self.CopyMode := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'Pen' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPen then begin
        Self.Pen := TPen( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Pen', 'TPen' );
    end else Result := TPersistent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TGraphic //////////////////

function TGraphic_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyGraphic;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TGraphic.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyGraphic.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TGraphic_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TGraphic;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TGraphic) then begin
      ErrorWrongExpectedType( argSelf, 'TGraphic' );
      Exit;
    end;
    realObj := TGraphic(obj);
    // Check attribute
    Result := TGraphic_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TGraphic_ReadAttribute( Self : TGraphic; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Empty' ) = 0 then Result := VariantAsPyObject( Self.Empty )
    else if CompareText( key, 'Height' ) = 0 then Result := VariantAsPyObject( Self.Height )
    else if CompareText( key, 'Modified' ) = 0 then Result := VariantAsPyObject( Self.Modified )
    else if CompareText( key, 'Palette' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'HPALETTE' ); Result := nil; end
    else if CompareText( key, 'PaletteModified' ) = 0 then Result := VariantAsPyObject( Self.PaletteModified )
    else if CompareText( key, 'Transparent' ) = 0 then Result := VariantAsPyObject( Self.Transparent )
    else if CompareText( key, 'Width' ) = 0 then Result := VariantAsPyObject( Self.Width )
    else if CompareText( key, 'OnChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnProgress' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TProgressEvent' ); Result := nil; end
    else Result := TPersistent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TGraphic_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TGraphic;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TGraphic) then begin
      ErrorWrongExpectedType( argSelf, 'TGraphic' );
      Exit;
    end;
    realObj := TGraphic(obj);
    // Check attribute
    Result := TGraphic_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TGraphic_WriteAttribute( Self : TGraphic; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Empty' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Height' ) = 0 then begin
      Self.Height := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Modified' ) = 0 then begin
      Self.Modified := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Palette' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'HPALETTE' );
    end else if CompareText( key, 'PaletteModified' ) = 0 then begin
      Self.PaletteModified := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Transparent' ) = 0 then begin
      Self.Transparent := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Width' ) = 0 then begin
      Self.Width := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGraphic then
          with TPyGraphic(Self) do
            OnChange := EventOnChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnProgress' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnProgress := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyGraphic then
          with TPyGraphic(Self) do
            OnProgress := EventOnProgress;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TPersistent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TPicture //////////////////

function TPicture_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyPicture;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TPicture.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyPicture.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TPicture_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPicture;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPicture) then begin
      ErrorWrongExpectedType( argSelf, 'TPicture' );
      Exit;
    end;
    realObj := TPicture(obj);
    // Check attribute
    Result := TPicture_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TPicture_ReadAttribute( Self : TPicture; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Bitmap' ) = 0 then Result := GetPythonObject( Self.Bitmap, 'Graphics', 'TBitmap' )
    else if CompareText( key, 'Graphic' ) = 0 then Result := GetPythonObject( Self.Graphic, 'Graphics', 'TGraphic' )
    else if CompareText( key, 'PictureAdapter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'IChangeNotifier' ); Result := nil; end
    else if CompareText( key, 'Height' ) = 0 then Result := VariantAsPyObject( Self.Height )
    else if CompareText( key, 'Icon' ) = 0 then Result := GetPythonObject( Self.Icon, 'Graphics', 'TIcon' )
    else if CompareText( key, 'Metafile' ) = 0 then Result := GetPythonObject( Self.Metafile, 'Graphics', 'TMetafile' )
    else if CompareText( key, 'Width' ) = 0 then Result := VariantAsPyObject( Self.Width )
    else if CompareText( key, 'OnChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnProgress' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TProgressEvent' ); Result := nil; end
    else Result := TPersistent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TPicture_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TPicture;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TPicture) then begin
      ErrorWrongExpectedType( argSelf, 'TPicture' );
      Exit;
    end;
    realObj := TPicture(obj);
    // Check attribute
    Result := TPicture_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TPicture_WriteAttribute( Self : TPicture; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Bitmap' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TBitmap then begin
        Self.Bitmap := TBitmap( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Bitmap', 'TBitmap' );
    end else if CompareText( key, 'Graphic' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TGraphic then begin
        Self.Graphic := TGraphic( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Graphic', 'TGraphic' );
    end else if CompareText( key, 'PictureAdapter' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'IChangeNotifier' );
    end else if CompareText( key, 'Height' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Icon' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TIcon then begin
        Self.Icon := TIcon( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Icon', 'TIcon' );
    end else if CompareText( key, 'Metafile' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TMetafile then begin
        Self.Metafile := TMetafile( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Metafile', 'TMetafile' );
    end else if CompareText( key, 'Width' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'OnChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPicture then
          with TPyPicture(Self) do
            OnChange := EventOnChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnProgress' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnProgress := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyPicture then
          with TPyPicture(Self) do
            OnProgress := EventOnProgress;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TPersistent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TMetafileCanvas //////////////////

function TMetafileCanvas_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyMetafileCanvas;
  argSelf : PPyObject;
  argAMetafile : PPyObject;
  objAMetafile : TMetafile;
  argReferenceDevice : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OOi:TMetafileCanvas.Create', [ @argSelf,
                  @argAMetafile,
                  @argReferenceDevice       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAMetafile := GetObjectOf( argAMetafile ) as TMetafile;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyMetafileCanvas.Create( objAMetafile, HDC(argReferenceDevice) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TMetafileCanvas_CreateWithComment( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyMetafileCanvas;
  argSelf : PPyObject;
  argAMetafile : PPyObject;
  objAMetafile : TMetafile;
  argReferenceDevice : Integer;
  argCreatedBy : PChar;
  argDescription : PChar;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OOiss:TMetafileCanvas.CreateWithComment', [ @argSelf,
                  @argAMetafile,
                  @argReferenceDevice,
                  @argCreatedBy,
                  @argDescription       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAMetafile := GetObjectOf( argAMetafile ) as TMetafile;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyMetafileCanvas.CreateWithComment( objAMetafile, HDC(argReferenceDevice), String(argCreatedBy), String(argDescription) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TMetafileCanvas_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMetafileCanvas;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMetafileCanvas) then begin
      ErrorWrongExpectedType( argSelf, 'TMetafileCanvas' );
      Exit;
    end;
    realObj := TMetafileCanvas(obj);
    // Check attribute
    Result := TMetafileCanvas_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TMetafileCanvas_ReadAttribute( Self : TMetafileCanvas; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TCanvas_ReadAttribute( Self, argSelf, key );
  end;
end;

function TMetafileCanvas_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMetafileCanvas;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMetafileCanvas) then begin
      ErrorWrongExpectedType( argSelf, 'TMetafileCanvas' );
      Exit;
    end;
    realObj := TMetafileCanvas(obj);
    // Check attribute
    Result := TMetafileCanvas_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TMetafileCanvas_WriteAttribute( Self : TMetafileCanvas; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TCanvas_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TSharedImage //////////////////

function TSharedImage_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPySharedImage;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TSharedImage.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPySharedImage.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TSharedImage_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TSharedImage;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TSharedImage) then begin
      ErrorWrongExpectedType( argSelf, 'TSharedImage' );
      Exit;
    end;
    realObj := TSharedImage(obj);
    // Check attribute
    Result := TSharedImage_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TSharedImage_ReadAttribute( Self : TSharedImage; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TSharedImage_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TSharedImage;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TSharedImage) then begin
      ErrorWrongExpectedType( argSelf, 'TSharedImage' );
      Exit;
    end;
    realObj := TSharedImage(obj);
    // Check attribute
    Result := TSharedImage_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TSharedImage_WriteAttribute( Self : TSharedImage; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TMetafileImage //////////////////

function TMetafileImage_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyMetafileImage;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TMetafileImage.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyMetafileImage.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TMetafileImage_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMetafileImage;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMetafileImage) then begin
      ErrorWrongExpectedType( argSelf, 'TMetafileImage' );
      Exit;
    end;
    realObj := TMetafileImage(obj);
    // Check attribute
    Result := TMetafileImage_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TMetafileImage_ReadAttribute( Self : TMetafileImage; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TSharedImage_ReadAttribute( Self, argSelf, key );
  end;
end;

function TMetafileImage_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMetafileImage;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMetafileImage) then begin
      ErrorWrongExpectedType( argSelf, 'TMetafileImage' );
      Exit;
    end;
    realObj := TMetafileImage(obj);
    // Check attribute
    Result := TMetafileImage_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TMetafileImage_WriteAttribute( Self : TMetafileImage; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TSharedImage_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TMetafile //////////////////

function TMetafile_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyMetafile;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TMetafile.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyMetafile.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TMetafile_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMetafile;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMetafile) then begin
      ErrorWrongExpectedType( argSelf, 'TMetafile' );
      Exit;
    end;
    realObj := TMetafile(obj);
    // Check attribute
    Result := TMetafile_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TMetafile_ReadAttribute( Self : TMetafile; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'CreatedBy' ) = 0 then Result := VariantAsPyObject( Self.CreatedBy )
    else if CompareText( key, 'Description' ) = 0 then Result := VariantAsPyObject( Self.Description )
    else if CompareText( key, 'Enhanced' ) = 0 then Result := VariantAsPyObject( Self.Enhanced )
    else if CompareText( key, 'Handle' ) = 0 then Result := VariantAsPyObject( Self.Handle )
    else if CompareText( key, 'MMWidth' ) = 0 then Result := VariantAsPyObject( Self.MMWidth )
    else if CompareText( key, 'MMHeight' ) = 0 then Result := VariantAsPyObject( Self.MMHeight )
    else if CompareText( key, 'Inch' ) = 0 then Result := VariantAsPyObject( Self.Inch )
    else Result := TGraphic_ReadAttribute( Self, argSelf, key );
  end;
end;

function TMetafile_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TMetafile;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TMetafile) then begin
      ErrorWrongExpectedType( argSelf, 'TMetafile' );
      Exit;
    end;
    realObj := TMetafile(obj);
    // Check attribute
    Result := TMetafile_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TMetafile_WriteAttribute( Self : TMetafile; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'CreatedBy' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Description' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Enhanced' ) = 0 then begin
      Self.Enhanced := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Handle' ) = 0 then begin
      Self.Handle := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'MMWidth' ) = 0 then begin
      Self.MMWidth := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'MMHeight' ) = 0 then begin
      Self.MMHeight := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Inch' ) = 0 then begin
      Self.Inch := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TGraphic_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TBitmapImage //////////////////

function TBitmapImage_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyBitmapImage;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TBitmapImage.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyBitmapImage.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TBitmapImage_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TBitmapImage;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TBitmapImage) then begin
      ErrorWrongExpectedType( argSelf, 'TBitmapImage' );
      Exit;
    end;
    realObj := TBitmapImage(obj);
    // Check attribute
    Result := TBitmapImage_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TBitmapImage_ReadAttribute( Self : TBitmapImage; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TSharedImage_ReadAttribute( Self, argSelf, key );
  end;
end;

function TBitmapImage_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TBitmapImage;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TBitmapImage) then begin
      ErrorWrongExpectedType( argSelf, 'TBitmapImage' );
      Exit;
    end;
    realObj := TBitmapImage(obj);
    // Check attribute
    Result := TBitmapImage_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TBitmapImage_WriteAttribute( Self : TBitmapImage; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TSharedImage_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TBitmap //////////////////

function TBitmap_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyBitmap;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TBitmap.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyBitmap.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TBitmap_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TBitmap;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TBitmap) then begin
      ErrorWrongExpectedType( argSelf, 'TBitmap' );
      Exit;
    end;
    realObj := TBitmap(obj);
    // Check attribute
    Result := TBitmap_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TBitmap_ReadAttribute( Self : TBitmap; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Canvas' ) = 0 then Result := GetPythonObject( Self.Canvas, 'Graphics', 'TCanvas' )
    else if CompareText( key, 'Handle' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'HBITMAP' ); Result := nil; end
    else if CompareText( key, 'HandleType' ) = 0 then Result := VariantAsPyObject( Integer( Self.HandleType ) )
    else if CompareText( key, 'IgnorePalette' ) = 0 then Result := VariantAsPyObject( Self.IgnorePalette )
    else if CompareText( key, 'MaskHandle' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'HBITMAP' ); Result := nil; end
    else if CompareText( key, 'Monochrome' ) = 0 then Result := VariantAsPyObject( Self.Monochrome )
    else if CompareText( key, 'PixelFormat' ) = 0 then Result := VariantAsPyObject( Integer( Self.PixelFormat ) )
    else if CompareText( key, 'TransparentColor' ) = 0 then Result := VariantAsPyObject( Integer( Self.TransparentColor ) )
    else if CompareText( key, 'TransparentMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.TransparentMode ) )
    else Result := TGraphic_ReadAttribute( Self, argSelf, key );
  end;
end;

function TBitmap_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TBitmap;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TBitmap) then begin
      ErrorWrongExpectedType( argSelf, 'TBitmap' );
      Exit;
    end;
    realObj := TBitmap(obj);
    // Check attribute
    Result := TBitmap_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TBitmap_WriteAttribute( Self : TBitmap; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Canvas' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Handle' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'HBITMAP' );
    end else if CompareText( key, 'HandleType' ) = 0 then begin
      Self.HandleType := TBitmapHandleType(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'IgnorePalette' ) = 0 then begin
      Self.IgnorePalette := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'MaskHandle' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Monochrome' ) = 0 then begin
      Self.Monochrome := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PixelFormat' ) = 0 then begin
      Self.PixelFormat := TPixelFormat(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TransparentColor' ) = 0 then begin
      Self.TransparentColor := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TransparentMode' ) = 0 then begin
      Self.TransparentMode := TTransparentMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else Result := TGraphic_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TIconImage //////////////////

function TIconImage_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyIconImage;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TIconImage.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyIconImage.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TIconImage_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TIconImage;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TIconImage) then begin
      ErrorWrongExpectedType( argSelf, 'TIconImage' );
      Exit;
    end;
    realObj := TIconImage(obj);
    // Check attribute
    Result := TIconImage_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TIconImage_ReadAttribute( Self : TIconImage; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TSharedImage_ReadAttribute( Self, argSelf, key );
  end;
end;

function TIconImage_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TIconImage;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TIconImage) then begin
      ErrorWrongExpectedType( argSelf, 'TIconImage' );
      Exit;
    end;
    realObj := TIconImage(obj);
    // Check attribute
    Result := TIconImage_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TIconImage_WriteAttribute( Self : TIconImage; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TSharedImage_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TIcon //////////////////

function TIcon_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyIcon;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TIcon.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyIcon.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TIcon_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TIcon;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TIcon) then begin
      ErrorWrongExpectedType( argSelf, 'TIcon' );
      Exit;
    end;
    realObj := TIcon(obj);
    // Check attribute
    Result := TIcon_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TIcon_ReadAttribute( Self : TIcon; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Handle' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'HICON' ); Result := nil; end
    else Result := TGraphic_ReadAttribute( Self, argSelf, key );
  end;
end;

function TIcon_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TIcon;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TIcon) then begin
      ErrorWrongExpectedType( argSelf, 'TIcon' );
      Exit;
    end;
    realObj := TIcon(obj);
    // Check attribute
    Result := TIcon_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TIcon_WriteAttribute( Self : TIcon; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Handle' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'HICON' );
    end else Result := TGraphic_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Initialization of the module ///////////

procedure TModule_Graphics.Initialize;
begin
  AddMethod( 'CreateGraphicsObject', TGraphicsObject_Create, '' );
  AddMethod( 'GraphicsObject_GetAttr', TGraphicsObject_GetAttr, '' );
  AddMethod( 'GraphicsObject_SetAttr', TGraphicsObject_SetAttr, '' );
  AddMethod( 'CreateFont', TFont_Create, '' );
  AddMethod( 'Font_GetAttr', TFont_GetAttr, '' );
  AddMethod( 'Font_SetAttr', TFont_SetAttr, '' );
  AddMethod( 'CreatePen', TPen_Create, '' );
  AddMethod( 'Pen_GetAttr', TPen_GetAttr, '' );
  AddMethod( 'Pen_SetAttr', TPen_SetAttr, '' );
  AddMethod( 'CreateBrush', TBrush_Create, '' );
  AddMethod( 'Brush_GetAttr', TBrush_GetAttr, '' );
  AddMethod( 'Brush_SetAttr', TBrush_SetAttr, '' );
  AddMethod( 'CreateCanvas', TCanvas_Create, '' );
  AddMethod( 'Canvas_GetAttr', TCanvas_GetAttr, '' );
  AddMethod( 'Canvas_SetAttr', TCanvas_SetAttr, '' );
  AddMethod( 'CreateGraphic', TGraphic_Create, '' );
  AddMethod( 'Graphic_GetAttr', TGraphic_GetAttr, '' );
  AddMethod( 'Graphic_SetAttr', TGraphic_SetAttr, '' );
  AddMethod( 'CreatePicture', TPicture_Create, '' );
  AddMethod( 'Picture_GetAttr', TPicture_GetAttr, '' );
  AddMethod( 'Picture_SetAttr', TPicture_SetAttr, '' );
  AddMethod( 'CreateMetafileCanvas', TMetafileCanvas_Create, '' );
  AddMethod( 'CreateWithCommentMetafileCanvas', TMetafileCanvas_CreateWithComment, '' );
  AddMethod( 'MetafileCanvas_GetAttr', TMetafileCanvas_GetAttr, '' );
  AddMethod( 'MetafileCanvas_SetAttr', TMetafileCanvas_SetAttr, '' );
  AddMethod( 'CreateSharedImage', TSharedImage_Create, '' );
  AddMethod( 'SharedImage_GetAttr', TSharedImage_GetAttr, '' );
  AddMethod( 'SharedImage_SetAttr', TSharedImage_SetAttr, '' );
  AddMethod( 'CreateMetafileImage', TMetafileImage_Create, '' );
  AddMethod( 'MetafileImage_GetAttr', TMetafileImage_GetAttr, '' );
  AddMethod( 'MetafileImage_SetAttr', TMetafileImage_SetAttr, '' );
  AddMethod( 'CreateMetafile', TMetafile_Create, '' );
  AddMethod( 'Metafile_GetAttr', TMetafile_GetAttr, '' );
  AddMethod( 'Metafile_SetAttr', TMetafile_SetAttr, '' );
  AddMethod( 'CreateBitmapImage', TBitmapImage_Create, '' );
  AddMethod( 'BitmapImage_GetAttr', TBitmapImage_GetAttr, '' );
  AddMethod( 'BitmapImage_SetAttr', TBitmapImage_SetAttr, '' );
  AddMethod( 'CreateBitmap', TBitmap_Create, '' );
  AddMethod( 'Bitmap_GetAttr', TBitmap_GetAttr, '' );
  AddMethod( 'Bitmap_SetAttr', TBitmap_SetAttr, '' );
  AddMethod( 'CreateIconImage', TIconImage_Create, '' );
  AddMethod( 'IconImage_GetAttr', TIconImage_GetAttr, '' );
  AddMethod( 'IconImage_SetAttr', TIconImage_SetAttr, '' );
  AddMethod( 'CreateIcon', TIcon_Create, '' );
  AddMethod( 'Icon_GetAttr', TIcon_GetAttr, '' );
  AddMethod( 'Icon_SetAttr', TIcon_SetAttr, '' );
  inherited;
end;

end.
