////
//  This file was generated by VCL Generator
//  Copyright 1998 - Morgan Martinet
//  07/04/98 17:26:13
//  it declares the content of the module _Forms
////

unit Python_Forms;

interface

uses
   Windows,
   Graphics,
   Menus,
   Controls,
   Forms,
   Classes,
   SysUtils,
   PythonEngine;

type
  TModule_Forms = class( TPythonModule )
  public
    procedure Initialize; override;
  end;

  function TControlScrollBar_ReadAttribute( Self : TControlScrollBar; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TControlScrollBar_WriteAttribute( Self : TControlScrollBar; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TScrollingWinControl_ReadAttribute( Self : TScrollingWinControl; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TScrollingWinControl_WriteAttribute( Self : TScrollingWinControl; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TScrollBox_ReadAttribute( Self : TScrollBox; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TScrollBox_WriteAttribute( Self : TScrollBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TDesigner_ReadAttribute( Self : TDesigner; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TDesigner_WriteAttribute( Self : TDesigner; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomForm_ReadAttribute( Self : TCustomForm; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomForm_WriteAttribute( Self : TCustomForm; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TForm_ReadAttribute( Self : TForm; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TForm_WriteAttribute( Self : TForm; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TDataModule_ReadAttribute( Self : TDataModule; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TDataModule_WriteAttribute( Self : TDataModule; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TScreen_ReadAttribute( Self : TScreen; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TScreen_WriteAttribute( Self : TScreen; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TApplication_ReadAttribute( Self : TApplication; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TApplication_WriteAttribute( Self : TApplication; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;

  procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 

implementation

uses
   Delphi_Classes,
   Python_Classes,
   Delphi_Graphics,
   Python_Graphics,
   Delphi_Menus,
   Python_Menus,
   Delphi_Controls,
   Python_Controls,
   Delphi_System,
   Delphi_Forms,
   Python_System,
   Py_Misc,
   PyRecords,
   PyDelphiAssoc;

var
  IsInitialized : Boolean;
  gForms : TModule_Forms;
procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 
begin
  if IsInitialized then
    Exit;
  IsInitialized := True;
  gForms := TModule_Forms.Create( AOwner );
  with gForms do
    begin
      Engine := AEngine;
      ModuleName := '_Forms';
    end;
end;

///////////// Functions for class TControlScrollBar //////////////////

function TControlScrollBar_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyControlScrollBar;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TControlScrollBar.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyControlScrollBar.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TControlScrollBar_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TControlScrollBar;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TControlScrollBar) then begin
      ErrorWrongExpectedType( argSelf, 'TControlScrollBar' );
      Exit;
    end;
    realObj := TControlScrollBar(obj);
    // Check attribute
    Result := TControlScrollBar_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TControlScrollBar_ReadAttribute( Self : TControlScrollBar; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Kind' ) = 0 then Result := VariantAsPyObject( Integer( Self.Kind ) )
    else if CompareText( key, 'ScrollPos' ) = 0 then Result := VariantAsPyObject( Self.ScrollPos )
    else if CompareText( key, 'Margin' ) = 0 then Result := VariantAsPyObject( Self.Margin )
    else if CompareText( key, 'Increment' ) = 0 then Result := VariantAsPyObject( Integer( Self.Increment ) )
    else if CompareText( key, 'Range' ) = 0 then Result := VariantAsPyObject( Self.Range )
    else if CompareText( key, 'Position' ) = 0 then Result := VariantAsPyObject( Self.Position )
    else if CompareText( key, 'Tracking' ) = 0 then Result := VariantAsPyObject( Self.Tracking )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else Result := TPersistent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TControlScrollBar_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TControlScrollBar;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TControlScrollBar) then begin
      ErrorWrongExpectedType( argSelf, 'TControlScrollBar' );
      Exit;
    end;
    realObj := TControlScrollBar(obj);
    // Check attribute
    Result := TControlScrollBar_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TControlScrollBar_WriteAttribute( Self : TControlScrollBar; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Kind' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ScrollPos' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Margin' ) = 0 then begin
      Self.Margin := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Increment' ) = 0 then begin
      Self.Increment := TScrollBarInc(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Range' ) = 0 then begin
      Self.Range := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Position' ) = 0 then begin
      Self.Position := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Tracking' ) = 0 then begin
      Self.Tracking := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TPersistent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TScrollingWinControl //////////////////

function TScrollingWinControl_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyScrollingWinControl;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TScrollingWinControl.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyScrollingWinControl.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TScrollingWinControl_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyScrollingWinControl;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TScrollingWinControl.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyScrollingWinControl.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TScrollingWinControl_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TScrollingWinControl;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TScrollingWinControl) then begin
      ErrorWrongExpectedType( argSelf, 'TScrollingWinControl' );
      Exit;
    end;
    realObj := TScrollingWinControl(obj);
    // Check attribute
    Result := TScrollingWinControl_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TScrollingWinControl_ReadAttribute( Self : TScrollingWinControl; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'HorzScrollBar' ) = 0 then Result := GetPythonObject( Self.HorzScrollBar, 'Forms', 'TControlScrollBar' )
    else if CompareText( key, 'VertScrollBar' ) = 0 then Result := GetPythonObject( Self.VertScrollBar, 'Forms', 'TControlScrollBar' )
    else Result := TWinControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TScrollingWinControl_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TScrollingWinControl;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TScrollingWinControl) then begin
      ErrorWrongExpectedType( argSelf, 'TScrollingWinControl' );
      Exit;
    end;
    realObj := TScrollingWinControl(obj);
    // Check attribute
    Result := TScrollingWinControl_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TScrollingWinControl_WriteAttribute( Self : TScrollingWinControl; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'HorzScrollBar' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TControlScrollBar then begin
        Self.HorzScrollBar := TControlScrollBar( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'HorzScrollBar', 'TControlScrollBar' );
    end else if CompareText( key, 'VertScrollBar' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TControlScrollBar then begin
        Self.VertScrollBar := TControlScrollBar( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'VertScrollBar', 'TControlScrollBar' );
    end else Result := TWinControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TScrollBox //////////////////

function TScrollBox_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyScrollBox;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TScrollBox.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyScrollBox.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TScrollBox_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyScrollBox;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TScrollBox.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyScrollBox.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TScrollBox_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TScrollBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TScrollBox) then begin
      ErrorWrongExpectedType( argSelf, 'TScrollBox' );
      Exit;
    end;
    realObj := TScrollBox(obj);
    // Check attribute
    Result := TScrollBox_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TScrollBox_ReadAttribute( Self : TScrollBox; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'AutoScroll' ) = 0 then Result := VariantAsPyObject( Self.AutoScroll )
    else if CompareText( key, 'BorderStyle' ) = 0 then Result := VariantAsPyObject( Integer( Self.BorderStyle ) )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'DragMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragMode ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'Forms', 'TFont' )
    else if CompareText( key, 'ParentColor' ) = 0 then Result := VariantAsPyObject( Self.ParentColor )
    else if CompareText( key, 'ParentCtl3D' ) = 0 then Result := VariantAsPyObject( Self.ParentCtl3D )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'ParentShowHint' ) = 0 then Result := VariantAsPyObject( Self.ParentShowHint )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'Forms', 'TPopupMenu' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnEndDrag' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TEndDragEvent' ); Result := nil; end
    else if CompareText( key, 'OnEnter' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnExit' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnResize' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else Result := TScrollingWinControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TScrollBox_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TScrollBox;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TScrollBox) then begin
      ErrorWrongExpectedType( argSelf, 'TScrollBox' );
      Exit;
    end;
    realObj := TScrollBox(obj);
    // Check attribute
    Result := TScrollBox_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TScrollBox_WriteAttribute( Self : TScrollBox; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'AutoScroll' ) = 0 then begin
      Self.AutoScroll := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BorderStyle' ) = 0 then begin
      Self.BorderStyle := TBorderStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DragMode' ) = 0 then begin
      Self.DragMode := TDragMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'ParentColor' ) = 0 then begin
      Self.ParentColor := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentCtl3D' ) = 0 then begin
      Self.ParentCtl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentShowHint' ) = 0 then begin
      Self.ParentShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBox then
          with TPyScrollBox(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBox then
          with TPyScrollBox(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBox then
          with TPyScrollBox(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBox then
          with TPyScrollBox(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEndDrag' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEndDrag := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBox then
          with TPyScrollBox(Self) do
            OnEndDrag := EventOnEndDrag;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnEnter' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnEnter := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBox then
          with TPyScrollBox(Self) do
            OnEnter := EventOnEnter;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnExit' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnExit := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBox then
          with TPyScrollBox(Self) do
            OnExit := EventOnExit;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBox then
          with TPyScrollBox(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBox then
          with TPyScrollBox(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBox then
          with TPyScrollBox(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnResize' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnResize := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScrollBox then
          with TPyScrollBox(Self) do
            OnResize := EventOnResize;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TScrollingWinControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TDesigner //////////////////

function TDesigner_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyDesigner;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TDesigner.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyDesigner.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TDesigner_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TDesigner;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TDesigner) then begin
      ErrorWrongExpectedType( argSelf, 'TDesigner' );
      Exit;
    end;
    realObj := TDesigner(obj);
    // Check attribute
    Result := TDesigner_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TDesigner_ReadAttribute( Self : TDesigner; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'IsControl' ) = 0 then Result := VariantAsPyObject( Self.IsControl )
    else if CompareText( key, 'Form' ) = 0 then Result := GetPythonObject( Self.Form, 'Forms', 'TCustomForm' )
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TDesigner_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TDesigner;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TDesigner) then begin
      ErrorWrongExpectedType( argSelf, 'TDesigner' );
      Exit;
    end;
    realObj := TDesigner(obj);
    // Check attribute
    Result := TDesigner_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TDesigner_WriteAttribute( Self : TDesigner; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'IsControl' ) = 0 then begin
      Self.IsControl := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Form' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TCustomForm then begin
        Self.Form := TCustomForm( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Form', 'TCustomForm' );
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomForm //////////////////

function TCustomForm_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomForm;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomForm.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomForm.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomForm_CreateNew( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomForm;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomForm.CreateNew', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomForm.CreateNew( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomForm_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomForm;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TCustomForm.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomForm.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomForm_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomForm;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomForm) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomForm' );
      Exit;
    end;
    realObj := TCustomForm(obj);
    // Check attribute
    Result := TCustomForm_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomForm_ReadAttribute( Self : TCustomForm; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Active' ) = 0 then Result := VariantAsPyObject( Self.Active )
    else if CompareText( key, 'ActiveControl' ) = 0 then Result := GetPythonObject( Self.ActiveControl, 'Forms', 'TWinControl' )
    else if CompareText( key, 'ActiveOleControl' ) = 0 then Result := GetPythonObject( Self.ActiveOleControl, 'Forms', 'TWinControl' )
    else if CompareText( key, 'Canvas' ) = 0 then Result := GetPythonObject( Self.Canvas, 'Forms', 'TCanvas' )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Designer' ) = 0 then Result := GetPythonObject( Self.Designer, 'Forms', 'TDesigner' )
    else if CompareText( key, 'DropTarget' ) = 0 then Result := VariantAsPyObject( Self.DropTarget )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'Forms', 'TFont' )
    else if CompareText( key, 'HelpFile' ) = 0 then Result := VariantAsPyObject( Self.HelpFile )
    else if CompareText( key, 'KeyPreview' ) = 0 then Result := VariantAsPyObject( Self.KeyPreview )
    else if CompareText( key, 'Menu' ) = 0 then Result := GetPythonObject( Self.Menu, 'Forms', 'TMainMenu' )
    else if CompareText( key, 'ModalResult' ) = 0 then Result := VariantAsPyObject( Integer( Self.ModalResult ) )
    else if CompareText( key, 'OleFormObject' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'IOleForm' ); Result := nil; end
    else if CompareText( key, 'WindowState' ) = 0 then Result := VariantAsPyObject( Integer( Self.WindowState ) )
    else Result := TScrollingWinControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomForm_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomForm;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomForm) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomForm' );
      Exit;
    end;
    realObj := TCustomForm(obj);
    // Check attribute
    Result := TCustomForm_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomForm_WriteAttribute( Self : TCustomForm; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Active' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ActiveControl' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TWinControl then begin
        Self.ActiveControl := TWinControl( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'ActiveControl', 'TWinControl' );
    end else if CompareText( key, 'ActiveOleControl' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TWinControl then begin
        Self.ActiveOleControl := TWinControl( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'ActiveOleControl', 'TWinControl' );
    end else if CompareText( key, 'Canvas' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Designer' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TDesigner then begin
        Self.Designer := TDesigner( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Designer', 'TDesigner' );
    end else if CompareText( key, 'DropTarget' ) = 0 then begin
      Self.DropTarget := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'HelpFile' ) = 0 then begin
      Self.HelpFile := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'KeyPreview' ) = 0 then begin
      Self.KeyPreview := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Menu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TMainMenu then begin
        Self.Menu := TMainMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Menu', 'TMainMenu' );
    end else if CompareText( key, 'ModalResult' ) = 0 then begin
      Self.ModalResult := TModalResult(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OleFormObject' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'IOleForm' );
    end else if CompareText( key, 'WindowState' ) = 0 then begin
      Self.WindowState := TWindowState(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else Result := TScrollingWinControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TForm //////////////////

function TForm_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyForm;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TForm.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyForm.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TForm_CreateNew( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyForm;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TForm.CreateNew', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyForm.CreateNew( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TForm_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyForm;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TForm.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyForm.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TForm_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TForm;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TForm) then begin
      ErrorWrongExpectedType( argSelf, 'TForm' );
      Exit;
    end;
    realObj := TForm(obj);
    // Check attribute
    Result := TForm_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TForm_ReadAttribute( Self : TForm; argSelf : PPyObject; key : PChar ) : PPyObject;
var
  tmpBorderIcons : TBorderIcons;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'ActiveMDIChild' ) = 0 then Result := GetPythonObject( Self.ActiveMDIChild, 'Forms', 'TForm' )
    else if CompareText( key, 'ClientHandle' ) = 0 then Result := VariantAsPyObject( Self.ClientHandle )
    else if CompareText( key, 'MDIChildCount' ) = 0 then Result := VariantAsPyObject( Self.MDIChildCount )
    else if CompareText( key, 'TileMode' ) = 0 then Result := VariantAsPyObject( Integer( Self.TileMode ) )
    else if CompareText( key, 'ActiveControl' ) = 0 then Result := GetPythonObject( Self.ActiveControl, 'Forms', 'TWinControl' )
    else if CompareText( key, 'BorderIcons' ) = 0 then begin
      tmpBorderIcons := Self.BorderIcons;
      Result := SetToList( @tmpBorderIcons, sizeof(tmpBorderIcons) )
    end
    else if CompareText( key, 'BorderStyle' ) = 0 then Result := VariantAsPyObject( Integer( Self.BorderStyle ) )
    else if CompareText( key, 'AutoScroll' ) = 0 then Result := VariantAsPyObject( Self.AutoScroll )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'ClientHeight' ) = 0 then Result := VariantAsPyObject( Self.ClientHeight )
    else if CompareText( key, 'ClientWidth' ) = 0 then Result := VariantAsPyObject( Self.ClientWidth )
    else if CompareText( key, 'Ctl3D' ) = 0 then Result := VariantAsPyObject( Self.Ctl3D )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'ParentFont' ) = 0 then Result := VariantAsPyObject( Self.ParentFont )
    else if CompareText( key, 'Font' ) = 0 then Result := GetPythonObject( Self.Font, 'Forms', 'TFont' )
    else if CompareText( key, 'FormStyle' ) = 0 then Result := VariantAsPyObject( Integer( Self.FormStyle ) )
    else if CompareText( key, 'Height' ) = 0 then Result := VariantAsPyObject( Self.Height )
    else if CompareText( key, 'HelpFile' ) = 0 then Result := VariantAsPyObject( Self.HelpFile )
    else if CompareText( key, 'HorzScrollBar' ) = 0 then Result := GetPythonObject( Self.HorzScrollBar, 'Forms', 'TControlScrollBar' )
    else if CompareText( key, 'Icon' ) = 0 then Result := GetPythonObject( Self.Icon, 'Forms', 'TIcon' )
    else if CompareText( key, 'KeyPreview' ) = 0 then Result := VariantAsPyObject( Self.KeyPreview )
    else if CompareText( key, 'Menu' ) = 0 then Result := GetPythonObject( Self.Menu, 'Forms', 'TMainMenu' )
    else if CompareText( key, 'ObjectMenuItem' ) = 0 then Result := GetPythonObject( Self.ObjectMenuItem, 'Forms', 'TMenuItem' )
    else if CompareText( key, 'PixelsPerInch' ) = 0 then Result := VariantAsPyObject( Self.PixelsPerInch )
    else if CompareText( key, 'PopupMenu' ) = 0 then Result := GetPythonObject( Self.PopupMenu, 'Forms', 'TPopupMenu' )
    else if CompareText( key, 'Position' ) = 0 then Result := VariantAsPyObject( Integer( Self.Position ) )
    else if CompareText( key, 'PrintScale' ) = 0 then Result := VariantAsPyObject( Integer( Self.PrintScale ) )
    else if CompareText( key, 'Scaled' ) = 0 then Result := VariantAsPyObject( Self.Scaled )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'VertScrollBar' ) = 0 then Result := GetPythonObject( Self.VertScrollBar, 'Forms', 'TControlScrollBar' )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'Width' ) = 0 then Result := VariantAsPyObject( Self.Width )
    else if CompareText( key, 'WindowState' ) = 0 then Result := VariantAsPyObject( Integer( Self.WindowState ) )
    else if CompareText( key, 'WindowMenu' ) = 0 then Result := GetPythonObject( Self.WindowMenu, 'Forms', 'TMenuItem' )
    else if CompareText( key, 'OnActivate' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnClose' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TCloseEvent' ); Result := nil; end
    else if CompareText( key, 'OnCloseQuery' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TCloseQueryEvent' ); Result := nil; end
    else if CompareText( key, 'OnCreate' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDblClick' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDestroy' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDeactivate' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragDrop' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragDropEvent' ); Result := nil; end
    else if CompareText( key, 'OnDragOver' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TDragOverEvent' ); Result := nil; end
    else if CompareText( key, 'OnHide' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnHelp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'THelpEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyPress' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyPressEvent' ); Result := nil; end
    else if CompareText( key, 'OnKeyUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TKeyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseDown' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseMove' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseMoveEvent' ); Result := nil; end
    else if CompareText( key, 'OnMouseUp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMouseEvent' ); Result := nil; end
    else if CompareText( key, 'OnPaint' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnResize' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnShow' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else Result := TCustomForm_ReadAttribute( Self, argSelf, key );
  end;
end;

function TForm_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TForm;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TForm) then begin
      ErrorWrongExpectedType( argSelf, 'TForm' );
      Exit;
    end;
    realObj := TForm(obj);
    // Check attribute
    Result := TForm_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TForm_WriteAttribute( Self : TForm; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
  tmpBorderIcons : TBorderIcons;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'ActiveMDIChild' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ClientHandle' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'MDIChildCount' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'TileMode' ) = 0 then begin
      Self.TileMode := TTileMode(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ActiveControl' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TWinControl then begin
        Self.ActiveControl := TWinControl( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'ActiveControl', 'TWinControl' );
    end else if CompareText( key, 'BorderIcons' ) = 0 then begin
      if PyList_Check(value) then begin
        ListToSet( value, @tmpBorderIcons, sizeof(tmpBorderIcons) );
        Self.BorderIcons := tmpBorderIcons;
        Result := PyInt_FromLong(0);
      end else
        ErrorWrongSetPropertyType( argSelf, 'BorderIcons', 'TBorderIcons' );
    end else if CompareText( key, 'BorderStyle' ) = 0 then begin
      Self.BorderStyle := TFormBorderStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'AutoScroll' ) = 0 then begin
      Self.AutoScroll := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ClientHeight' ) = 0 then begin
      Self.ClientHeight := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ClientWidth' ) = 0 then begin
      Self.ClientWidth := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Ctl3D' ) = 0 then begin
      Self.Ctl3D := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ParentFont' ) = 0 then begin
      Self.ParentFont := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Font' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.Font := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Font', 'TFont' );
    end else if CompareText( key, 'FormStyle' ) = 0 then begin
      Self.FormStyle := TFormStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Height' ) = 0 then begin
      Self.Height := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'HelpFile' ) = 0 then begin
      Self.HelpFile := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'HorzScrollBar' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TControlScrollBar then begin
        Self.HorzScrollBar := TControlScrollBar( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'HorzScrollBar', 'TControlScrollBar' );
    end else if CompareText( key, 'Icon' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TIcon then begin
        Self.Icon := TIcon( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Icon', 'TIcon' );
    end else if CompareText( key, 'KeyPreview' ) = 0 then begin
      Self.KeyPreview := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Menu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TMainMenu then begin
        Self.Menu := TMainMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Menu', 'TMainMenu' );
    end else if CompareText( key, 'ObjectMenuItem' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TMenuItem then begin
        Self.ObjectMenuItem := TMenuItem( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'ObjectMenuItem', 'TMenuItem' );
    end else if CompareText( key, 'PixelsPerInch' ) = 0 then begin
      Self.PixelsPerInch := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PopupMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TPopupMenu then begin
        Self.PopupMenu := TPopupMenu( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'PopupMenu', 'TPopupMenu' );
    end else if CompareText( key, 'Position' ) = 0 then begin
      Self.Position := TPosition(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'PrintScale' ) = 0 then begin
      Self.PrintScale := TPrintScale(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Scaled' ) = 0 then begin
      Self.Scaled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'VertScrollBar' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TControlScrollBar then begin
        Self.VertScrollBar := TControlScrollBar( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'VertScrollBar', 'TControlScrollBar' );
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Width' ) = 0 then begin
      Self.Width := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'WindowState' ) = 0 then begin
      Self.WindowState := TWindowState(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'WindowMenu' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TMenuItem then begin
        Self.WindowMenu := TMenuItem( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'WindowMenu', 'TMenuItem' );
    end else if CompareText( key, 'OnActivate' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnActivate := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnActivate := EventOnActivate;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnClick := EventOnClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnClose' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnClose := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnClose := EventOnClose;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnCloseQuery' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnCloseQuery := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnCloseQuery := EventOnCloseQuery;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnCreate' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnCreate := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnCreate := EventOnCreate;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDblClick' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDblClick := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnDblClick := EventOnDblClick;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDestroy' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDestroy := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnDestroy := EventOnDestroy;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDeactivate' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDeactivate := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnDeactivate := EventOnDeactivate;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragDrop' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragDrop := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnDragDrop := EventOnDragDrop;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDragOver' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDragOver := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnDragOver := EventOnDragOver;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnHide' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnHide := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnHide := EventOnHide;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnHelp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnHelp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnHelp := EventOnHelp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnKeyDown := EventOnKeyDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyPress' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyPress := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnKeyPress := EventOnKeyPress;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnKeyUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnKeyUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnKeyUp := EventOnKeyUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseDown' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseDown := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnMouseDown := EventOnMouseDown;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseMove' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseMove := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnMouseMove := EventOnMouseMove;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMouseUp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMouseUp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnMouseUp := EventOnMouseUp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnPaint' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnPaint := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnPaint := EventOnPaint;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnResize' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnResize := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnResize := EventOnResize;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnShow' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnShow := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyForm then
          with TPyForm(Self) do
            OnShow := EventOnShow;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TCustomForm_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TDataModule //////////////////

function TDataModule_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyDataModule;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TDataModule.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyDataModule.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TDataModule_CreateNew( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyDataModule;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TDataModule.CreateNew', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyDataModule.CreateNew( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TDataModule_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TDataModule;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TDataModule) then begin
      ErrorWrongExpectedType( argSelf, 'TDataModule' );
      Exit;
    end;
    realObj := TDataModule(obj);
    // Check attribute
    Result := TDataModule_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TDataModule_ReadAttribute( Self : TDataModule; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'DesignOffset' ) = 0 then Result := CreatePoint( Self.DesignOffset ).GetSelf
    else if CompareText( key, 'DesignSize' ) = 0 then Result := CreatePoint( Self.DesignSize ).GetSelf
    else if CompareText( key, 'OnCreate' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDestroy' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else Result := TComponent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TDataModule_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TDataModule;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TDataModule) then begin
      ErrorWrongExpectedType( argSelf, 'TDataModule' );
      Exit;
    end;
    realObj := TDataModule(obj);
    // Check attribute
    Result := TDataModule_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TDataModule_WriteAttribute( Self : TDataModule; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'DesignOffset' ) = 0 then begin
      Self.DesignOffset := PyObjectAsPoint( Value );      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DesignSize' ) = 0 then begin
      Self.DesignSize := PyObjectAsPoint( Value );      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnCreate' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnCreate := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyDataModule then
          with TPyDataModule(Self) do
            OnCreate := EventOnCreate;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDestroy' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDestroy := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyDataModule then
          with TPyDataModule(Self) do
            OnDestroy := EventOnDestroy;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TComponent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TScreen //////////////////

function TScreen_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TScreen.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    DefInterfaceObject( Screen, argSelf, False );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TScreen_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TScreen;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TScreen) then begin
      ErrorWrongExpectedType( argSelf, 'TScreen' );
      Exit;
    end;
    realObj := TScreen(obj);
    // Check attribute
    Result := TScreen_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TScreen_ReadAttribute( Self : TScreen; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'ActiveControl' ) = 0 then Result := GetPythonObject( Self.ActiveControl, 'Forms', 'TWinControl' )
    else if CompareText( key, 'ActiveCustomForm' ) = 0 then Result := GetPythonObject( Self.ActiveCustomForm, 'Forms', 'TCustomForm' )
    else if CompareText( key, 'ActiveForm' ) = 0 then Result := GetPythonObject( Self.ActiveForm, 'Forms', 'TForm' )
    else if CompareText( key, 'CustomFormCount' ) = 0 then Result := VariantAsPyObject( Self.CustomFormCount )
    else if CompareText( key, 'Cursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.Cursor ) )
    else if CompareText( key, 'DataModuleCount' ) = 0 then Result := VariantAsPyObject( Self.DataModuleCount )
    else if CompareText( key, 'IconFont' ) = 0 then Result := GetPythonObject( Self.IconFont, 'Forms', 'TFont' )
    else if CompareText( key, 'Fonts' ) = 0 then Result := GetPythonObject( Self.Fonts, 'Forms', 'TStrings' )
    else if CompareText( key, 'FormCount' ) = 0 then Result := VariantAsPyObject( Self.FormCount )
    else if CompareText( key, 'Imes' ) = 0 then Result := GetPythonObject( Self.Imes, 'Forms', 'TStrings' )
    else if CompareText( key, 'DefaultIme' ) = 0 then Result := VariantAsPyObject( Self.DefaultIme )
    else if CompareText( key, 'DefaultKbLayout' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'HKL' ); Result := nil; end
    else if CompareText( key, 'Height' ) = 0 then Result := VariantAsPyObject( Self.Height )
    else if CompareText( key, 'PixelsPerInch' ) = 0 then Result := VariantAsPyObject( Self.PixelsPerInch )
    else if CompareText( key, 'Width' ) = 0 then Result := VariantAsPyObject( Self.Width )
    else if CompareText( key, 'OnActiveControlChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnActiveFormChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else Result := TComponent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TScreen_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TScreen;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TScreen) then begin
      ErrorWrongExpectedType( argSelf, 'TScreen' );
      Exit;
    end;
    realObj := TScreen(obj);
    // Check attribute
    Result := TScreen_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TScreen_WriteAttribute( Self : TScreen; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'ActiveControl' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ActiveCustomForm' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ActiveForm' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'CustomFormCount' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Cursor' ) = 0 then begin
      Self.Cursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DataModuleCount' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'IconFont' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TFont then begin
        Self.IconFont := TFont( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'IconFont', 'TFont' );
    end else if CompareText( key, 'Fonts' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'FormCount' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Imes' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'DefaultIme' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'DefaultKbLayout' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Height' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'PixelsPerInch' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Width' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'OnActiveControlChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnActiveControlChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScreen then
          with TPyScreen(Self) do
            OnActiveControlChange := EventOnActiveControlChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnActiveFormChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnActiveFormChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyScreen then
          with TPyScreen(Self) do
            OnActiveFormChange := EventOnActiveFormChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TComponent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TApplication //////////////////

function TApplication_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TApplication.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    DefInterfaceObject( Application, argSelf, False );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TApplication_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TApplication;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TApplication) then begin
      ErrorWrongExpectedType( argSelf, 'TApplication' );
      Exit;
    end;
    realObj := TApplication(obj);
    // Check attribute
    Result := TApplication_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TApplication_ReadAttribute( Self : TApplication; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Active' ) = 0 then Result := VariantAsPyObject( Self.Active )
    else if CompareText( key, 'AllowTesting' ) = 0 then Result := VariantAsPyObject( Self.AllowTesting )
    else if CompareText( key, 'CurrentHelpFile' ) = 0 then Result := VariantAsPyObject( Self.CurrentHelpFile )
    else if CompareText( key, 'DialogHandle' ) = 0 then Result := VariantAsPyObject( Self.DialogHandle )
    else if CompareText( key, 'ExeName' ) = 0 then Result := VariantAsPyObject( Self.ExeName )
    else if CompareText( key, 'Handle' ) = 0 then Result := VariantAsPyObject( Self.Handle )
    else if CompareText( key, 'HelpFile' ) = 0 then Result := VariantAsPyObject( Self.HelpFile )
    else if CompareText( key, 'Hint' ) = 0 then Result := VariantAsPyObject( Self.Hint )
    else if CompareText( key, 'HintColor' ) = 0 then Result := VariantAsPyObject( Integer( Self.HintColor ) )
    else if CompareText( key, 'HintPause' ) = 0 then Result := VariantAsPyObject( Self.HintPause )
    else if CompareText( key, 'HintShortPause' ) = 0 then Result := VariantAsPyObject( Self.HintShortPause )
    else if CompareText( key, 'HintHidePause' ) = 0 then Result := VariantAsPyObject( Self.HintHidePause )
    else if CompareText( key, 'Icon' ) = 0 then Result := GetPythonObject( Self.Icon, 'Forms', 'TIcon' )
    else if CompareText( key, 'MainForm' ) = 0 then Result := GetPythonObject( Self.MainForm, 'Forms', 'TForm' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'ShowMainForm' ) = 0 then Result := VariantAsPyObject( Self.ShowMainForm )
    else if CompareText( key, 'Terminated' ) = 0 then Result := VariantAsPyObject( Self.Terminated )
    else if CompareText( key, 'Title' ) = 0 then Result := VariantAsPyObject( Self.Title )
    else if CompareText( key, 'UpdateFormatSettings' ) = 0 then Result := VariantAsPyObject( Self.UpdateFormatSettings )
    else if CompareText( key, 'UpdateMetricSettings' ) = 0 then Result := VariantAsPyObject( Self.UpdateMetricSettings )
    else if CompareText( key, 'OnActivate' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnDeactivate' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnException' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TExceptionEvent' ); Result := nil; end
    else if CompareText( key, 'OnIdle' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TIdleEvent' ); Result := nil; end
    else if CompareText( key, 'OnHelp' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'THelpEvent' ); Result := nil; end
    else if CompareText( key, 'OnHint' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnMessage' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TMessageEvent' ); Result := nil; end
    else if CompareText( key, 'OnMinimize' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnRestore' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'OnShowHint' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TShowHintEvent' ); Result := nil; end
    else Result := TComponent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TApplication_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TApplication;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TApplication) then begin
      ErrorWrongExpectedType( argSelf, 'TApplication' );
      Exit;
    end;
    realObj := TApplication(obj);
    // Check attribute
    Result := TApplication_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TApplication_WriteAttribute( Self : TApplication; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Active' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'AllowTesting' ) = 0 then begin
      Self.AllowTesting := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'CurrentHelpFile' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'DialogHandle' ) = 0 then begin
      Self.DialogHandle := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ExeName' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Handle' ) = 0 then begin
      Self.Handle := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'HelpFile' ) = 0 then begin
      Self.HelpFile := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Hint' ) = 0 then begin
      Self.Hint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'HintColor' ) = 0 then begin
      Self.HintColor := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'HintPause' ) = 0 then begin
      Self.HintPause := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'HintShortPause' ) = 0 then begin
      Self.HintShortPause := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'HintHidePause' ) = 0 then begin
      Self.HintHidePause := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Icon' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TIcon then begin
        Self.Icon := TIcon( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Icon', 'TIcon' );
    end else if CompareText( key, 'MainForm' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ShowMainForm' ) = 0 then begin
      Self.ShowMainForm := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Terminated' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Title' ) = 0 then begin
      Self.Title := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'UpdateFormatSettings' ) = 0 then begin
      Self.UpdateFormatSettings := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'UpdateMetricSettings' ) = 0 then begin
      Self.UpdateMetricSettings := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnActivate' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnActivate := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyApplication then
          with TPyApplication(Self) do
            OnActivate := EventOnActivate;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnDeactivate' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnDeactivate := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyApplication then
          with TPyApplication(Self) do
            OnDeactivate := EventOnDeactivate;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnException' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnException := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyApplication then
          with TPyApplication(Self) do
            OnException := EventOnException;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnIdle' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnIdle := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyApplication then
          with TPyApplication(Self) do
            OnIdle := EventOnIdle;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnHelp' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnHelp := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyApplication then
          with TPyApplication(Self) do
            OnHelp := EventOnHelp;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnHint' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnHint := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyApplication then
          with TPyApplication(Self) do
            OnHint := EventOnHint;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMessage' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMessage := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyApplication then
          with TPyApplication(Self) do
            OnMessage := EventOnMessage;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnMinimize' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnMinimize := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyApplication then
          with TPyApplication(Self) do
            OnMinimize := EventOnMinimize;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnRestore' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnRestore := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyApplication then
          with TPyApplication(Self) do
            OnRestore := EventOnRestore;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'OnShowHint' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnShowHint := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyApplication then
          with TPyApplication(Self) do
            OnShowHint := EventOnShowHint;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else Result := TComponent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Initialization of the module ///////////

procedure TModule_Forms.Initialize;
begin
  AddMethod( 'CreateControlScrollBar', TControlScrollBar_Create, '' );
  AddMethod( 'ControlScrollBar_GetAttr', TControlScrollBar_GetAttr, '' );
  AddMethod( 'ControlScrollBar_SetAttr', TControlScrollBar_SetAttr, '' );
  AddMethod( 'CreateScrollingWinControl', TScrollingWinControl_Create, '' );
  AddMethod( 'CreateParentedScrollingWinControl', TScrollingWinControl_CreateParented, '' );
  AddMethod( 'ScrollingWinControl_GetAttr', TScrollingWinControl_GetAttr, '' );
  AddMethod( 'ScrollingWinControl_SetAttr', TScrollingWinControl_SetAttr, '' );
  AddMethod( 'CreateScrollBox', TScrollBox_Create, '' );
  AddMethod( 'CreateParentedScrollBox', TScrollBox_CreateParented, '' );
  AddMethod( 'ScrollBox_GetAttr', TScrollBox_GetAttr, '' );
  AddMethod( 'ScrollBox_SetAttr', TScrollBox_SetAttr, '' );
  AddMethod( 'CreateDesigner', TDesigner_Create, '' );
  AddMethod( 'Designer_GetAttr', TDesigner_GetAttr, '' );
  AddMethod( 'Designer_SetAttr', TDesigner_SetAttr, '' );
  AddMethod( 'CreateCustomForm', TCustomForm_Create, '' );
  AddMethod( 'CreateNewCustomForm', TCustomForm_CreateNew, '' );
  AddMethod( 'CreateParentedCustomForm', TCustomForm_CreateParented, '' );
  AddMethod( 'CustomForm_GetAttr', TCustomForm_GetAttr, '' );
  AddMethod( 'CustomForm_SetAttr', TCustomForm_SetAttr, '' );
  AddMethod( 'CreateForm', TForm_Create, '' );
  AddMethod( 'CreateNewForm', TForm_CreateNew, '' );
  AddMethod( 'CreateParentedForm', TForm_CreateParented, '' );
  AddMethod( 'Form_GetAttr', TForm_GetAttr, '' );
  AddMethod( 'Form_SetAttr', TForm_SetAttr, '' );
  AddMethod( 'CreateDataModule', TDataModule_Create, '' );
  AddMethod( 'CreateNewDataModule', TDataModule_CreateNew, '' );
  AddMethod( 'DataModule_GetAttr', TDataModule_GetAttr, '' );
  AddMethod( 'DataModule_SetAttr', TDataModule_SetAttr, '' );
  AddMethod( 'CreateScreen', TScreen_Create, '' );
  AddMethod( 'Screen_GetAttr', TScreen_GetAttr, '' );
  AddMethod( 'Screen_SetAttr', TScreen_SetAttr, '' );
  AddMethod( 'CreateApplication', TApplication_Create, '' );
  AddMethod( 'Application_GetAttr', TApplication_GetAttr, '' );
  AddMethod( 'Application_SetAttr', TApplication_SetAttr, '' );
  inherited;
end;

end.
