////
//  This file was generated by VCL Generator
//  Copyright 1998 - Morgan Martinet
//  07/04/98 17:26:18
//  it subclasses all classes of the unit StdCtrls
////

unit Delphi_StdCtrls;

interface

uses
  Messages,
  Windows,
  SysUtils,
  Classes,
  Controls,
  Forms,
  Menus,
  Graphics,
  StdCtrls,
  PythonEngine,
  PyVarArg,
  PyRecords,
  PyDelphiAssoc;

type
  TPyCustomGroupBox = class( TCustomGroupBox )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyGroupBox = class( TGroupBox )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyCustomLabel = class( TCustomLabel )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyLabel = class( TLabel )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyCustomEdit = class( TCustomEdit )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyEdit = class( TEdit )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnChange( Sender : TObject );
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnKeyPress( Sender : TObject; var Key : Char );
    procedure EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyCustomMemo = class( TCustomMemo )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyMemo = class( TMemo )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnChange( Sender : TObject );
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnKeyPress( Sender : TObject; var Key : Char );
    procedure EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyCustomComboBox = class( TCustomComboBox )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyComboBox = class( TComboBox )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnChange( Sender : TObject );
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnDrawItem( Control : TWinControl; Index : Integer; Rect : TRect; State : TOwnerDrawState );
    procedure EventOnDropDown( Sender : TObject );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnKeyPress( Sender : TObject; var Key : Char );
    procedure EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnMeasureItem( Control : TWinControl; Index : Integer; var Height : Integer );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyButtonControl = class( TButtonControl )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyButton = class( TButton )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnKeyPress( Sender : TObject; var Key : Char );
    procedure EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyCustomCheckBox = class( TCustomCheckBox )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyCheckBox = class( TCheckBox )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnKeyPress( Sender : TObject; var Key : Char );
    procedure EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyRadioButton = class( TRadioButton )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnKeyPress( Sender : TObject; var Key : Char );
    procedure EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyCustomListBox = class( TCustomListBox )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyListBox = class( TListBox )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnDrawItem( Control : TWinControl; Index : Integer; Rect : TRect; State : TOwnerDrawState );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnKeyPress( Sender : TObject; var Key : Char );
    procedure EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnMeasureItem( Control : TWinControl; Index : Integer; var Height : Integer );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyScrollBar = class( TScrollBar )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnChange( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnKeyPress( Sender : TObject; var Key : Char );
    procedure EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnScroll( Sender : TObject; ScrollCode : TScrollCode; var ScrollPos : Integer );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyCustomStaticText = class( TCustomStaticText )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyStaticText = class( TStaticText )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;


implementation

Uses Py_Misc;

/////////// class TPyCustomGroupBox /////////////////////

destructor TPyCustomGroupBox.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyGroupBox /////////////////////

destructor TPyGroupBox.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyGroupBox.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TGroupBox' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyGroupBox.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TGroupBox' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyGroupBox.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TGroupBox' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TGroupBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyGroupBox.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TGroupBox' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TGroupBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyGroupBox.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TGroupBox' ) ); 
    L.Add( GetPythonObject( Target, 'StdCtrls', 'TGroupBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyGroupBox.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TGroupBox' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyGroupBox.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TGroupBox' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyGroupBox.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TGroupBox' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyGroupBox.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TGroupBox' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyGroupBox.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TGroupBox' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyGroupBox.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TGroupBox' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'StdCtrls', 'TGroupBox' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyCustomLabel /////////////////////

destructor TPyCustomLabel.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyLabel /////////////////////

destructor TPyLabel.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyLabel.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TLabel' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyLabel.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TLabel' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyLabel.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TLabel' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TLabel' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyLabel.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TLabel' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TLabel' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyLabel.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TLabel' ) ); 
    L.Add( GetPythonObject( Target, 'StdCtrls', 'TLabel' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyLabel.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TLabel' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyLabel.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TLabel' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyLabel.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TLabel' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyLabel.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TLabel' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'StdCtrls', 'TLabel' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyCustomEdit /////////////////////

destructor TPyCustomEdit.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyEdit /////////////////////

destructor TPyEdit.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyEdit.EventOnChange( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    rslt := ExecuteEvent( 'OnChange', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TEdit' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TEdit' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    L.Add( GetPythonObject( Target, 'StdCtrls', 'TEdit' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyDown', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnKeyPress( Sender : TObject; var Key : Char );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.Py_None ).GetSelf ); 
    rslt := ExecuteEvent( 'OnKeyPress', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyUp', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyEdit.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TEdit' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'StdCtrls', 'TEdit' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyCustomMemo /////////////////////

destructor TPyCustomMemo.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyMemo /////////////////////

destructor TPyMemo.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyMemo.EventOnChange( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    rslt := ExecuteEvent( 'OnChange', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TMemo' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TMemo' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    L.Add( GetPythonObject( Target, 'StdCtrls', 'TMemo' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyDown', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnKeyPress( Sender : TObject; var Key : Char );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.Py_None ).GetSelf ); 
    rslt := ExecuteEvent( 'OnKeyPress', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyUp', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyMemo.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TMemo' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'StdCtrls', 'TMemo' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyCustomComboBox /////////////////////

destructor TPyCustomComboBox.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyComboBox /////////////////////

destructor TPyComboBox.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyComboBox.EventOnChange( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    rslt := ExecuteEvent( 'OnChange', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TComboBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TComboBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnDrawItem( Control : TWinControl; Index : Integer; Rect : TRect; State : TOwnerDrawState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Control, 'StdCtrls', 'TComboBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Index ) ); 
    L.Add( CreateRect( Rect ).GetSelf ); 
    L.Add( SetToList( @State, sizeof(State) ) ); 
    rslt := ExecuteEvent( 'OnDrawItem', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnDropDown( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    rslt := ExecuteEvent( 'OnDropDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    L.Add( GetPythonObject( Target, 'StdCtrls', 'TComboBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyDown', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnKeyPress( Sender : TObject; var Key : Char );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.Py_None ).GetSelf ); 
    rslt := ExecuteEvent( 'OnKeyPress', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyUp', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnMeasureItem( Control : TWinControl; Index : Integer; var Height : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Control, 'StdCtrls', 'TComboBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Index ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Height ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnMeasureItem', TDelphiAssoc(__assoc__), L, args );
    Height := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[2]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyComboBox.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TComboBox' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'StdCtrls', 'TComboBox' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyButtonControl /////////////////////

destructor TPyButtonControl.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyButton /////////////////////

destructor TPyButton.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyButton.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyButton.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TButton' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyButton.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TButton' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyButton.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    L.Add( GetPythonObject( Target, 'StdCtrls', 'TButton' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyButton.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyButton.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyButton.EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyDown', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyButton.EventOnKeyPress( Sender : TObject; var Key : Char );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.Py_None ).GetSelf ); 
    rslt := ExecuteEvent( 'OnKeyPress', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyButton.EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyUp', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyButton.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyButton.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyButton.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyButton.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TButton' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'StdCtrls', 'TButton' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyCustomCheckBox /////////////////////

destructor TPyCustomCheckBox.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyCheckBox /////////////////////

destructor TPyCheckBox.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyCheckBox.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyCheckBox.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyCheckBox.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyCheckBox.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( GetPythonObject( Target, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyCheckBox.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyCheckBox.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyCheckBox.EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyDown', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyCheckBox.EventOnKeyPress( Sender : TObject; var Key : Char );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.Py_None ).GetSelf ); 
    rslt := ExecuteEvent( 'OnKeyPress', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyCheckBox.EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyUp', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyCheckBox.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyCheckBox.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyCheckBox.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyCheckBox.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TCheckBox' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'StdCtrls', 'TCheckBox' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyRadioButton /////////////////////

destructor TPyRadioButton.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyRadioButton.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( GetPythonObject( Target, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyDown', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnKeyPress( Sender : TObject; var Key : Char );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.Py_None ).GetSelf ); 
    rslt := ExecuteEvent( 'OnKeyPress', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyUp', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyRadioButton.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TRadioButton' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'StdCtrls', 'TRadioButton' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyCustomListBox /////////////////////

destructor TPyCustomListBox.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyListBox /////////////////////

destructor TPyListBox.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyListBox.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TListBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TListBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnDrawItem( Control : TWinControl; Index : Integer; Rect : TRect; State : TOwnerDrawState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Control, 'StdCtrls', 'TListBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Index ) ); 
    L.Add( CreateRect( Rect ).GetSelf ); 
    L.Add( SetToList( @State, sizeof(State) ) ); 
    rslt := ExecuteEvent( 'OnDrawItem', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    L.Add( GetPythonObject( Target, 'StdCtrls', 'TListBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyDown', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnKeyPress( Sender : TObject; var Key : Char );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.Py_None ).GetSelf ); 
    rslt := ExecuteEvent( 'OnKeyPress', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyUp', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnMeasureItem( Control : TWinControl; Index : Integer; var Height : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Control, 'StdCtrls', 'TListBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Index ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Height ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnMeasureItem', TDelphiAssoc(__assoc__), L, args );
    Height := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[2]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyListBox.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TListBox' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'StdCtrls', 'TListBox' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyScrollBar /////////////////////

destructor TPyScrollBar.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyScrollBar.EventOnChange( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TScrollBar' ) ); 
    rslt := ExecuteEvent( 'OnChange', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBar.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TScrollBar' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TScrollBar' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBar.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TScrollBar' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TScrollBar' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBar.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TScrollBar' ) ); 
    L.Add( GetPythonObject( Target, 'StdCtrls', 'TScrollBar' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBar.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TScrollBar' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBar.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TScrollBar' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBar.EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TScrollBar' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyDown', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBar.EventOnKeyPress( Sender : TObject; var Key : Char );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TScrollBar' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.Py_None ).GetSelf ); 
    rslt := ExecuteEvent( 'OnKeyPress', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBar.EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TScrollBar' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyUp', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBar.EventOnScroll( Sender : TObject; ScrollCode : TScrollCode; var ScrollPos : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TScrollBar' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(ScrollCode) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( ScrollPos ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnScroll', TDelphiAssoc(__assoc__), L, args );
    ScrollPos := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[2]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBar.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TScrollBar' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'StdCtrls', 'TScrollBar' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyCustomStaticText /////////////////////

destructor TPyCustomStaticText.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyStaticText /////////////////////

destructor TPyStaticText.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyStaticText.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TStaticText' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyStaticText.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TStaticText' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyStaticText.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TStaticText' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TStaticText' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyStaticText.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TStaticText' ) ); 
    L.Add( GetPythonObject( Source, 'StdCtrls', 'TStaticText' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyStaticText.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TStaticText' ) ); 
    L.Add( GetPythonObject( Target, 'StdCtrls', 'TStaticText' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyStaticText.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TStaticText' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyStaticText.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TStaticText' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyStaticText.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TStaticText' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyStaticText.EventOnStartDrag( Sender : TObject; var DragObject : TDragObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'StdCtrls', 'TStaticText' ) ); 
    L.Add( CreateVarArg( GetPythonObject( DragObject, 'StdCtrls', 'TStaticText' ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnStartDrag', TDelphiAssoc(__assoc__), L, args );
    DragObject := GetObjectOf( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) as TDragObject;
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;


end.
