////
//  This file was generated by VCL Generator
//  Copyright 1998 - Morgan Martinet
//  07/04/98 17:26:14
//  it subclasses all classes of the unit Forms
////

unit Delphi_Forms;

interface

uses
  Messages,
  Windows,
  SysUtils,
  Classes,
  Graphics,
  Menus,
  Controls,
  Imm,
  Forms,
  PythonEngine,
  PyVarArg,
  PyRecords,
  PyDelphiAssoc;

type
  TPyControlScrollBar = class( TControlScrollBar )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyScrollingWinControl = class( TScrollingWinControl )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyScrollBox = class( TScrollBox )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnClick( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
    procedure EventOnEnter( Sender : TObject );
    procedure EventOnExit( Sender : TObject );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnResize( Sender : TObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyDesigner = class( TDesigner )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyCustomForm = class( TCustomForm )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyForm = class( TForm )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnActivate( Sender : TObject );
    procedure EventOnClick( Sender : TObject );
    procedure EventOnClose( Sender : TObject; var Action : TCloseAction );
    procedure EventOnCloseQuery( Sender : TObject; var CanClose : Boolean );
    procedure EventOnCreate( Sender : TObject );
    procedure EventOnDblClick( Sender : TObject );
    procedure EventOnDestroy( Sender : TObject );
    procedure EventOnDeactivate( Sender : TObject );
    procedure EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
    procedure EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
    procedure EventOnHide( Sender : TObject );
    function  EventOnHelp( Command : Word; Data : Longint; var CallHelp : Boolean ) : Boolean;
    procedure EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnKeyPress( Sender : TObject; var Key : Char );
    procedure EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
    procedure EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
    procedure EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
    procedure EventOnPaint( Sender : TObject );
    procedure EventOnResize( Sender : TObject );
    procedure EventOnShow( Sender : TObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyDataModule = class( TDataModule )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnCreate( Sender : TObject );
    procedure EventOnDestroy( Sender : TObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyScreen = class( TScreen )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnActiveControlChange( Sender : TObject );
    procedure EventOnActiveFormChange( Sender : TObject );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;

  TPyApplication = class( TApplication )
  protected
    FAssoc : Integer;
  public
    destructor Destroy; override;
    procedure EventOnActivate( Sender : TObject );
    procedure EventOnDeactivate( Sender : TObject );
    procedure EventOnException( Sender : TObject; E : Exception );
    procedure EventOnIdle( Sender : TObject; var Done : Boolean );
    function  EventOnHelp( Command : Word; Data : Longint; var CallHelp : Boolean ) : Boolean;
    procedure EventOnHint( Sender : TObject );
    procedure EventOnMessage( var Msg : TMsg; var Handled : Boolean );
    procedure EventOnMinimize( Sender : TObject );
    procedure EventOnRestore( Sender : TObject );
    procedure EventOnShowHint( var HintStr : string; var CanShow : Boolean; var HintInfo : THintInfo );
  published
    property __assoc__ : Integer read FAssoc write FAssoc;
  end;


implementation

Uses Py_Misc;

/////////// class TPyControlScrollBar /////////////////////

destructor TPyControlScrollBar.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyScrollingWinControl /////////////////////

destructor TPyScrollingWinControl.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyScrollBox /////////////////////

destructor TPyScrollBox.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyScrollBox.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScrollBox' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBox.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScrollBox' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBox.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScrollBox' ) ); 
    L.Add( GetPythonObject( Source, 'Forms', 'TScrollBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBox.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScrollBox' ) ); 
    L.Add( GetPythonObject( Source, 'Forms', 'TScrollBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBox.EventOnEndDrag( Sender, Target : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScrollBox' ) ); 
    L.Add( GetPythonObject( Target, 'Forms', 'TScrollBox' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnEndDrag', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBox.EventOnEnter( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScrollBox' ) ); 
    rslt := ExecuteEvent( 'OnEnter', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBox.EventOnExit( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScrollBox' ) ); 
    rslt := ExecuteEvent( 'OnExit', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBox.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScrollBox' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBox.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScrollBox' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBox.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScrollBox' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScrollBox.EventOnResize( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScrollBox' ) ); 
    rslt := ExecuteEvent( 'OnResize', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyDesigner /////////////////////

destructor TPyDesigner.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyCustomForm /////////////////////

destructor TPyCustomForm.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

/////////// class TPyForm /////////////////////

destructor TPyForm.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyForm.EventOnActivate( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    rslt := ExecuteEvent( 'OnActivate', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    rslt := ExecuteEvent( 'OnClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnClose( Sender : TObject; var Action : TCloseAction );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.PyInt_FromLong( Integer(Action) ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnClose', TDelphiAssoc(__assoc__), L, args );
    Action := TCloseAction( GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnCloseQuery( Sender : TObject; var CanClose : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( CanClose ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnCloseQuery', TDelphiAssoc(__assoc__), L, args );
    CanClose := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnCreate( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    rslt := ExecuteEvent( 'OnCreate', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnDblClick( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    rslt := ExecuteEvent( 'OnDblClick', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnDestroy( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    rslt := ExecuteEvent( 'OnDestroy', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnDeactivate( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    rslt := ExecuteEvent( 'OnDeactivate', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnDragDrop( Sender, Source : TObject; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    L.Add( GetPythonObject( Source, 'Forms', 'TForm' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnDragDrop', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnDragOver( Sender, Source : TObject; X, Y : Integer; State : TDragState; var Accept : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    L.Add( GetPythonObject( Source, 'Forms', 'TForm' ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(State) ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Accept ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnDragOver', TDelphiAssoc(__assoc__), L, args );
    Accept := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[5]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnHide( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    rslt := ExecuteEvent( 'OnHide', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

function TPyForm.EventOnHelp( Command : Word; Data : Longint; var CallHelp : Boolean ) : Boolean;
begin
end;

procedure TPyForm.EventOnKeyDown( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyDown', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnKeyPress( Sender : TObject; var Key : Char );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.Py_None ).GetSelf ); 
    rslt := ExecuteEvent( 'OnKeyPress', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnKeyUp( Sender : TObject; var Key : Word; Shift : TShiftState );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Key ) ).GetSelf ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    rslt := ExecuteEvent( 'OnKeyUp', TDelphiAssoc(__assoc__), L, args );
    Key := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnMouseDown( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseDown', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnMouseMove( Sender : TObject; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseMove', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnMouseUp( Sender : TObject; Button : TMouseButton; Shift : TShiftState; X, Y : Integer );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    L.Add( GetPythonEngine.PyInt_FromLong( Integer(Button) ) ); 
    L.Add( SetToList( @Shift, sizeof(Shift) ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( X ) ); 
    L.Add( GetPythonEngine.VariantAsPyObject( Y ) ); 
    rslt := ExecuteEvent( 'OnMouseUp', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnPaint( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    rslt := ExecuteEvent( 'OnPaint', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnResize( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    rslt := ExecuteEvent( 'OnResize', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyForm.EventOnShow( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TForm' ) ); 
    rslt := ExecuteEvent( 'OnShow', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyDataModule /////////////////////

destructor TPyDataModule.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyDataModule.EventOnCreate( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TDataModule' ) ); 
    rslt := ExecuteEvent( 'OnCreate', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyDataModule.EventOnDestroy( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TDataModule' ) ); 
    rslt := ExecuteEvent( 'OnDestroy', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyScreen /////////////////////

destructor TPyScreen.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyScreen.EventOnActiveControlChange( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScreen' ) ); 
    rslt := ExecuteEvent( 'OnActiveControlChange', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyScreen.EventOnActiveFormChange( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TScreen' ) ); 
    rslt := ExecuteEvent( 'OnActiveFormChange', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

/////////// class TPyApplication /////////////////////

destructor TPyApplication.Destroy;
begin
  ClearInterface( TDelphiAssoc(FAssoc) );
  FAssoc := 0;
  inherited;
end;

procedure TPyApplication.EventOnActivate( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TApplication' ) ); 
    rslt := ExecuteEvent( 'OnActivate', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyApplication.EventOnDeactivate( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TApplication' ) ); 
    rslt := ExecuteEvent( 'OnDeactivate', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyApplication.EventOnException( Sender : TObject; E : Exception );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TApplication' ) ); 
    L.Add( GetPythonEngine.Py_None ); 
    rslt := ExecuteEvent( 'OnException', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyApplication.EventOnIdle( Sender : TObject; var Done : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TApplication' ) ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Done ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnIdle', TDelphiAssoc(__assoc__), L, args );
    Done := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

function TPyApplication.EventOnHelp( Command : Word; Data : Longint; var CallHelp : Boolean ) : Boolean;
begin
end;

procedure TPyApplication.EventOnHint( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TApplication' ) ); 
    rslt := ExecuteEvent( 'OnHint', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyApplication.EventOnMessage( var Msg : TMsg; var Handled : Boolean );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( CreateVarArg( GetPythonEngine.Py_None ).GetSelf ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( Handled ) ).GetSelf ); 
    rslt := ExecuteEvent( 'OnMessage', TDelphiAssoc(__assoc__), L, args );
    Handled := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyApplication.EventOnMinimize( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TApplication' ) ); 
    rslt := ExecuteEvent( 'OnMinimize', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyApplication.EventOnRestore( Sender : TObject );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( GetPythonObject( Sender, 'Forms', 'TApplication' ) ); 
    rslt := ExecuteEvent( 'OnRestore', TDelphiAssoc(__assoc__), L, args );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;

procedure TPyApplication.EventOnShowHint( var HintStr : string; var CanShow : Boolean; var HintInfo : THintInfo );
var
  args, rslt : PPyObject;
  L : TList;
begin
  L := TList.Create;
  try
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( HintStr ) ).GetSelf ); 
    L.Add( CreateVarArg( GetPythonEngine.VariantAsPyObject( CanShow ) ).GetSelf ); 
    L.Add( CreateVarArg( GetPythonEngine.Py_None ).GetSelf ); 
    rslt := ExecuteEvent( 'OnShowHint', TDelphiAssoc(__assoc__), L, args );
    HintStr := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[0]) ) );
    CanShow := GetPythonEngine.PyObjectAsVariant( ExtractValueOfVarArg( PPyObject(L.Items[1]) ) );
    GetPythonEngine.Py_XDecRef( rslt );
    GetPythonEngine.Py_XDecRef( args );
  finally
    L.Free;
  end;
end;


end.
