import relocate__skel, ilu, getopt, socket

program = "relocate server"
mainloopvar = None

class Foo (relocate__skel.Foo):
	def __init__(self, server, ih):
		self.IluInstHandle = ih
		self.IluServer = server

	def dummy (self):
		pass

def reloc (pinfo, tinfo):
	print "relocating to", pinfo, tinfo
	return (pinfo, tinfo,)

def main(argv):
	global program, mainloopvar
	pinfo = "iiop"
	second = "23456"
	tinfo1 = None
	tinfo2 = None

	program = argv[0]
	hostname = socket.gethostname()
	opts, args = getopt.getopt(argv[1:], "p:1:2:")
	for opt in opts:
		if (opt[0] == '-p'):
			pinfo = opt[1]
		if (opt[0] == '-1'):
			tinfo1 = ("sunrpcrm", "tcp_%s_%s" % (hostname, opt[1]))
		if (opt[0] == '-2'):
			tinfo2 = ("sunrpcrm", "tcp_%s_%s" % (hostname, opt[1]))

	if not tinfo1 or not tinfo2:
		print "Usage:  %s [-p PROTOCOL] -1 PORT1 -2 PORT2" % (argv[0])
		return 1
	server = ilu.CreateServer("relocate-server", tinfo1, pinfo, None)
	server.addPort (tinfo2, pinfo)
	relocate = lambda a=pinfo, b=tinfo2: reloc(a, b)
	server.setRelocator(relocate)
	dummy = Foo(server, "dummy")
	dummy.IluPublish()
	print dummy.IluSBH()
	mainloopvar = ilu.CreateLoopHandle()
	ilu.RunMainLoop(mainloopvar)

if __name__ == "__main__":
	import sys
	main(sys.argv)
