/* test dynamically loaded modules

Compiled with:

mwcc -xms -O4 -rostr -export all -I./Include -I. -lroot -ldll python \
-nodup hellomodule.c -o hellomodule.so -map hellomodule.so.xMAP

*/

#include <stdio.h>
#include "Python.h"

#pragma export on
void inithello( void );
#pragma export reset

static PyObject *hello( PyObject *self, PyObject *args )
{
	if( !PyArg_NoArgs( args ) ) {
		return NULL;
	}

	return PyString_FromString( "Hello, this is the hellomodule." );
}

static PyMethodDef hello_methods[] = {
	{ "hello", hello, 0, "say hello" },
	{ NULL, NULL }
};

void inithello( void )
{
	(void)Py_InitModule4( "hello",
						  hello_methods,
						  "silly test module",
						  (PyObject *)NULL,
						  PYTHON_API_VERSION );
}
